/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.rest.audit.RestResponseEntityAuditResourceResolver;
import org.apereo.cas.rest.factory.CasProtocolServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.ChainingRestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.CompositeServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.DefaultTicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.DefaultUserAuthenticationResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.ServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.TicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.UserAuthenticationResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.apereo.cas.rest.plan.DefaultServiceTicketResourceEntityResponseFactoryPlan;
import org.apereo.cas.rest.plan.RestHttpRequestCredentialFactoryConfigurer;
import org.apereo.cas.rest.plan.ServiceTicketResourceEntityResponseFactoryConfigurer;
import org.apereo.cas.rest.plan.ServiceTicketResourceEntityResponseFactoryPlan;
import org.apereo.cas.support.rest.resources.ServiceTicketResource;
import org.apereo.cas.support.rest.resources.TicketGrantingTicketResource;
import org.apereo.cas.support.rest.resources.TicketStatusResource;
import org.apereo.cas.support.rest.resources.UserAuthenticationResource;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.AuthenticationThrottlingExecutionPlan;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration(value="casRestConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasRestConfiguration
implements RestHttpRequestCredentialFactoryConfigurer,
ServiceTicketResourceEntityResponseFactoryConfigurer,
AuditTrailRecordResolutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasRestConfiguration.class);
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ArgumentExtractor argumentExtractor;

    @Bean
    public TicketStatusResource ticketStatusResource() {
        return new TicketStatusResource(this.centralAuthenticationService);
    }

    @Bean
    @Autowired
    public ServiceTicketResource serviceTicketResource(@Qualifier(value="serviceTicketResourceEntityResponseFactory") ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory) {
        return new ServiceTicketResource(this.authenticationSystemSupport, this.ticketRegistrySupport, this.argumentExtractor, serviceTicketResourceEntityResponseFactory);
    }

    @Bean
    @ConditionalOnMissingBean(name={"serviceTicketResourceEntityResponseFactory"})
    @Autowired
    public ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory(List<ServiceTicketResourceEntityResponseFactoryConfigurer> configurers) {
        DefaultServiceTicketResourceEntityResponseFactoryPlan plan = new DefaultServiceTicketResourceEntityResponseFactoryPlan();
        configurers.forEach(c -> c.configureEntityResponseFactory((ServiceTicketResourceEntityResponseFactoryPlan)plan));
        return new CompositeServiceTicketResourceEntityResponseFactory(plan.getFactories());
    }

    @Bean
    @ConditionalOnMissingBean(name={"ticketGrantingTicketResourceEntityResponseFactory"})
    public TicketGrantingTicketResourceEntityResponseFactory ticketGrantingTicketResourceEntityResponseFactory() {
        return new DefaultTicketGrantingTicketResourceEntityResponseFactory();
    }

    @Bean
    @ConditionalOnMissingBean(name={"userAuthenticationResourceEntityResponseFactory"})
    public UserAuthenticationResourceEntityResponseFactory userAuthenticationResourceEntityResponseFactory() {
        return new DefaultUserAuthenticationResourceEntityResponseFactory();
    }

    @Autowired
    @Bean
    public TicketGrantingTicketResource ticketResourceRestController(@Qualifier(value="restHttpRequestCredentialFactory") RestHttpRequestCredentialFactory restHttpRequestCredentialFactory) {
        return new TicketGrantingTicketResource(this.authenticationSystemSupport, restHttpRequestCredentialFactory, this.centralAuthenticationService, this.webApplicationServiceFactory, this.ticketGrantingTicketResourceEntityResponseFactory());
    }

    @Autowired
    @Bean
    public UserAuthenticationResource userAuthenticationRestController(@Qualifier(value="restHttpRequestCredentialFactory") RestHttpRequestCredentialFactory restHttpRequestCredentialFactory) {
        return new UserAuthenticationResource(this.authenticationSystemSupport, restHttpRequestCredentialFactory, this.webApplicationServiceFactory, this.userAuthenticationResourceEntityResponseFactory());
    }

    @Autowired
    @Bean
    public RestHttpRequestCredentialFactory restHttpRequestCredentialFactory(List<RestHttpRequestCredentialFactoryConfigurer> configurers) {
        LOGGER.debug("building chainingRestHttpRequestCredentialFactory from {}", configurers);
        ChainingRestHttpRequestCredentialFactory factory = new ChainingRestHttpRequestCredentialFactory(new RestHttpRequestCredentialFactory[0]);
        configurers.forEach(c -> {
            LOGGER.debug("configuring credential factory: {}", c);
            c.configureCredentialFactory(factory);
        });
        return factory;
    }

    public void configureCredentialFactory(ChainingRestHttpRequestCredentialFactory factory) {
        factory.registerCredentialFactory((RestHttpRequestCredentialFactory)new UsernamePasswordRestHttpRequestCredentialFactory());
    }

    public void configureEntityResponseFactory(ServiceTicketResourceEntityResponseFactoryPlan plan) {
        plan.registerFactory((ServiceTicketResourceEntityResponseFactory)new CasProtocolServiceTicketResourceEntityResponseFactory(this.centralAuthenticationService));
    }

    public void configureAuditTrailRecordResolutionPlan(AuditTrailRecordResolutionPlan plan) {
        plan.registerAuditActionResolver("REST_API_TICKET_GRANTING_TICKET_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_FAILED"));
        plan.registerAuditResourceResolver("REST_API_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER", (AuditResourceResolver)new RestResponseEntityAuditResourceResolver(false));
        plan.registerAuditActionResolver("REST_API_SERVICE_TICKET_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_FAILED"));
        plan.registerAuditResourceResolver("REST_API_SERVICE_TICKET_RESOURCE_RESOLVER", (AuditResourceResolver)new RestResponseEntityAuditResourceResolver(true));
    }

    @Configuration(value="casRestThrottlingConfiguration")
    @ConditionalOnMissingBean(name={"restAuthenticationThrottle"})
    public static class CasRestThrottlingConfiguration
    extends WebMvcConfigurerAdapter {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(CasRestThrottlingConfiguration.class);
        @Autowired
        @Qualifier(value="authenticationThrottlingExecutionPlan")
        private ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan;

        public void addInterceptors(InterceptorRegistry registry) {
            AuthenticationThrottlingExecutionPlan plan = (AuthenticationThrottlingExecutionPlan)this.authenticationThrottlingExecutionPlan.getIfAvailable();
            LOGGER.debug("Activating authentication throttling for REST endpoints...");
            plan.getAuthenticationThrottleInterceptors().forEach(handler -> registry.addInterceptor(handler).addPathPatterns(new String[]{"/v1/**"}));
        }
    }
}

