/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.util.Map;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteInterpreterManagedProcess
extends RemoteInterpreterProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterManagedProcess.class);
    private final String interpreterPortRange;
    private String host = null;
    private int port = -1;
    private final String interpreterDir;
    private final String localRepoDir;
    private final String interpreterSettingName;
    private final String interpreterGroupId;
    private final boolean isUserImpersonated;
    private String errorMessage;
    private Map<String, String> env;

    public RemoteInterpreterManagedProcess(int intpEventServerPort, String intpEventServerHost, String interpreterPortRange, String intpDir, String localRepoDir, Map<String, String> env, int connectTimeout, int connectionPoolSize, String interpreterSettingName, String interpreterGroupId, boolean isUserImpersonated) {
        super(connectTimeout, connectionPoolSize, intpEventServerHost, intpEventServerPort);
        this.interpreterPortRange = interpreterPortRange;
        this.env = env;
        this.interpreterDir = intpDir;
        this.localRepoDir = localRepoDir;
        this.interpreterSettingName = interpreterSettingName;
        this.interpreterGroupId = interpreterGroupId;
        this.isUserImpersonated = isUserImpersonated;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        LOGGER.info("Stop interpreter process for interpreter group: {}", (Object)this.getInterpreterGroupId());
        try {
            this.callRemoteFunction(client -> {
                client.shutdown();
                return null;
            });
            this.shutdown();
        }
        catch (Exception e) {
            LOGGER.warn("ignore the exception when shutting down", (Throwable)e);
        }
    }

    @Override
    public void processStarted(int port, String host) {
        this.port = port;
        this.host = host;
    }

    public void processStopped(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public String getLocalRepoDir() {
        return this.localRepoDir;
    }

    public String getInterpreterDir() {
        return this.interpreterDir;
    }

    public String getIntpEventServerHost() {
        return this.intpEventServerHost;
    }

    public String getInterpreterPortRange() {
        return this.interpreterPortRange;
    }

    public String getInterpreterSettingName() {
        return this.interpreterSettingName;
    }

    public String getInterpreterGroupId() {
        return this.interpreterGroupId;
    }

    public boolean isUserImpersonated() {
        return this.isUserImpersonated;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

