/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.zformat;

import com.google.gson.annotations.SerializedName;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.jupyter.zformat.Result;

public class Paragraph {
    public static final String FINISHED = "FINISHED";
    @SerializedName(value="config")
    private Map<String, Object> config;
    @SerializedName(value="text")
    private String text;
    @SerializedName(value="results")
    private Result results;
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="status")
    private String status;

    public Paragraph() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        this.id = dateFormat.format(new Date()) + "_" + super.hashCode();
        this.status = FINISHED;
        this.initializeConfig();
    }

    private void initializeConfig() {
        this.config = new HashMap<String, Object>();
        this.config.put("editorHide", false);
        this.config.put("editorMode", "ace/mode/python");
    }

    public void setUpMarkdownConfig(boolean toActiveEditOnDblClickMode) {
        HashMap<String, Object> editorSetting = new HashMap<String, Object>();
        editorSetting.put("language", "markdown");
        editorSetting.put("editOnDblClick", toActiveEditOnDblClickMode);
        this.config.put("editorHide", toActiveEditOnDblClickMode);
        this.config.put("editorSetting", editorSetting);
        this.config.put("editorMode", "ace/mode/markdown");
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Result getResults() {
        return this.results;
    }

    public void setResults(Result results) {
        this.results = results;
    }

    public String getId() {
        return this.id;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }
}

