/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.com.google.common.collect;

import org.apache.zeppelin.jupyter.com.google.common.annotations.GwtCompatible;
import org.apache.zeppelin.jupyter.com.google.common.annotations.GwtIncompatible;
import org.apache.zeppelin.jupyter.com.google.common.collect.AbstractMapBasedMultiset;
import org.apache.zeppelin.jupyter.com.google.common.collect.Iterables;
import org.apache.zeppelin.jupyter.com.google.common.collect.Multisets;
import org.apache.zeppelin.jupyter.com.google.common.collect.ObjectCountHashMap;

@GwtCompatible(serializable=true, emulated=true)
public class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return HashMultiset.create(3);
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    HashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    void init(int distinctElements) {
        this.backingMap = new ObjectCountHashMap(distinctElements);
    }
}

