/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.JobListener;
import org.apache.zeppelin.scheduler.JobProgressPoller;

public abstract class JobWithProgressPoller<T>
extends Job<T> {
    private transient JobProgressPoller progressPoller;
    private long progressUpdateIntervalMs;

    public JobWithProgressPoller(String jobId, String jobName, JobListener listener, long progressUpdateIntervalMs) {
        super(jobId, jobName, listener);
        this.progressUpdateIntervalMs = progressUpdateIntervalMs;
    }

    public JobWithProgressPoller(String jobId, String jobName, JobListener listener) {
        this(jobId, jobName, listener, 500L);
    }

    public JobWithProgressPoller(String jobId, JobListener listener) {
        this(jobId, jobId, listener);
    }

    @Override
    public void onJobStarted() {
        super.onJobStarted();
        this.progressPoller = new JobProgressPoller(this, this.progressUpdateIntervalMs);
        this.progressPoller.start();
    }

    @Override
    public void onJobEnded() {
        super.onJobEnded();
        if (this.progressPoller != null) {
            this.progressPoller.interrupt();
        }
    }
}

