/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.scheduler.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job<T> {
    private static Logger LOGGER = LoggerFactory.getLogger(Job.class);
    private static SimpleDateFormat JOB_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private String jobName;
    private String id;
    private Date dateCreated;
    private Date dateStarted;
    private Date dateFinished;
    protected volatile Status status;
    transient boolean aborted = false;
    private volatile String errorMessage;
    private volatile transient Throwable exception;
    private transient JobListener listener;

    public Job(String jobName, JobListener listener) {
        this.jobName = jobName;
        this.listener = listener;
        this.dateCreated = new Date();
        this.id = JOB_DATE_FORMAT.format(this.dateCreated) + "_" + jobName;
        this.setStatus(Status.READY);
    }

    public Job(String jobId, String jobName, JobListener listener) {
        this.jobName = jobName;
        this.listener = listener;
        this.dateCreated = new Date();
        this.id = jobId;
        this.setStatus(Status.READY);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return ((Job)o).id.equals(this.id);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatusWithoutNotification(Status status) {
        this.status = status;
    }

    public void setStatus(Status status) {
        if (this.status == status) {
            return;
        }
        Status before = this.status;
        Status after = status;
        this.status = status;
        if (this.listener != null && before != null && before != after) {
            this.listener.onStatusChange(this, before, after);
        }
    }

    public void setListener(JobListener listener) {
        this.listener = listener;
    }

    public JobListener getListener() {
        return this.listener;
    }

    public boolean isTerminated() {
        return !this.status.isReady() && !this.status.isRunning() && !this.status.isPending();
    }

    public boolean isRunning() {
        return this.status.isRunning();
    }

    public void onJobStarted() {
        this.dateStarted = new Date();
    }

    public void onJobEnded() {
        this.dateFinished = new Date();
    }

    public void run() {
        try {
            this.onJobStarted();
            this.completeWithSuccess(this.jobRun());
        }
        catch (Throwable e) {
            LOGGER.error("Job failed", e);
            this.completeWithError(e);
        }
        finally {
            this.onJobEnded();
        }
    }

    private void completeWithSuccess(T result) {
        this.setResult(result);
        this.exception = null;
        this.errorMessage = null;
    }

    private void completeWithError(Throwable error) {
        this.setException(error);
        this.errorMessage = this.getJobExceptionStack(error);
    }

    private String getJobExceptionStack(Throwable e) {
        if (e == null) {
            return "";
        }
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        if (cause != null) {
            return ExceptionUtils.getStackTrace((Throwable)cause);
        }
        return ExceptionUtils.getStackTrace((Throwable)e);
    }

    public Throwable getException() {
        return this.exception;
    }

    protected void setException(Throwable t) {
        this.exception = t;
    }

    public abstract T getReturn();

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public abstract int progress();

    public abstract Map<String, Object> info();

    protected abstract T jobRun() throws Throwable;

    protected abstract boolean jobAbort();

    public void abort() {
        this.aborted = this.jobAbort();
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getDateStarted() {
        return this.dateStarted;
    }

    public void setDateStarted(Date startedAt) {
        this.dateStarted = startedAt;
    }

    public Date getDateFinished() {
        return this.dateFinished;
    }

    public void setDateFinished(Date finishedAt) {
        this.dateFinished = finishedAt;
    }

    public abstract void setResult(T var1);

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static enum Status {
        UNKNOWN,
        READY,
        PENDING,
        RUNNING,
        FINISHED,
        ERROR,
        ABORT;


        public boolean isReady() {
            return this == READY;
        }

        public boolean isRunning() {
            return this == RUNNING;
        }

        public boolean isPending() {
            return this == PENDING;
        }

        public boolean isCompleted() {
            return this == FINISHED || this == ERROR || this == ABORT;
        }
    }
}

