/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.ArrayList;
import java.util.List;
import org.apache.zeppelin.conf.ZeppelinConfiguration;

public class InterpreterOption {
    public static final transient String SHARED = "shared";
    public static final transient String SCOPED = "scoped";
    public static final transient String ISOLATED = "isolated";
    private static ZeppelinConfiguration conf = ZeppelinConfiguration.create();
    boolean remote = true;
    String host = null;
    int port = -1;
    String perNote;
    String perUser;
    boolean isExistingProcess;
    boolean setPermission;
    List<String> owners;
    boolean isUserImpersonate;

    public boolean isExistingProcess() {
        return this.isExistingProcess;
    }

    public void setExistingProcess(boolean isExistingProcess) {
        this.isExistingProcess = isExistingProcess;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean permissionIsSet() {
        return this.setPermission;
    }

    public void setUserPermission(boolean setPermission) {
        this.setPermission = setPermission;
    }

    public List<String> getOwners() {
        if (null != this.owners && conf.isUsernameForceLowerCase()) {
            ArrayList<String> lowerCaseUsers = new ArrayList<String>();
            for (String owner : this.owners) {
                lowerCaseUsers.add(owner.toLowerCase());
            }
            return lowerCaseUsers;
        }
        return this.owners;
    }

    public boolean isUserImpersonate() {
        return this.isUserImpersonate;
    }

    public void setUserImpersonate(boolean userImpersonate) {
        this.isUserImpersonate = userImpersonate;
    }

    public InterpreterOption() {
    }

    public InterpreterOption(String perUser, String perNote) {
        if (perUser == null) {
            throw new NullPointerException("perUser can not be null.");
        }
        if (perNote == null) {
            throw new NullPointerException("perNote can not be null.");
        }
        this.perUser = perUser;
        this.perNote = perNote;
    }

    public static InterpreterOption fromInterpreterOption(InterpreterOption other) {
        InterpreterOption option = new InterpreterOption();
        option.remote = other.remote;
        option.host = other.host;
        option.port = other.port;
        option.perNote = other.perNote;
        option.perUser = other.perUser;
        option.isExistingProcess = other.isExistingProcess;
        option.setPermission = other.setPermission;
        option.owners = null == other.owners ? new ArrayList<String>() : new ArrayList<String>(other.owners);
        return option;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean perUserShared() {
        return SHARED.equals(this.perUser);
    }

    public boolean perUserScoped() {
        return SCOPED.equals(this.perUser);
    }

    public boolean perUserIsolated() {
        return ISOLATED.equals(this.perUser);
    }

    public boolean perNoteShared() {
        return SHARED.equals(this.perNote);
    }

    public boolean perNoteScoped() {
        return SCOPED.equals(this.perNote);
    }

    public boolean perNoteIsolated() {
        return ISOLATED.equals(this.perNote);
    }

    public boolean isIsolated() {
        return this.perUserIsolated() || this.perNoteIsolated();
    }

    public boolean isSession() {
        return this.perUserScoped() || this.perNoteScoped();
    }

    public void setPerNote(String perNote) {
        this.perNote = perNote;
    }

    public void setPerUser(String perUser) {
        this.perUser = perUser;
    }
}

