/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.nio.file.Paths;
import org.apache.commons.lang3.Validate;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.zeppelin.dep.RepositoryListener;
import org.apache.zeppelin.dep.RepositorySystemFactory;
import org.apache.zeppelin.dep.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;

public class Booter {
    private static Logger logger = LoggerFactory.getLogger(Booter.class);

    public static RepositorySystem newRepositorySystem() {
        return RepositorySystemFactory.newRepositorySystem();
    }

    public static RepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepoPath) {
        Validate.notNull((Object)localRepoPath, (String)"localRepoPath should have a value", (Object[])new Object[0]);
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(Booter.resolveLocalRepoPath(localRepoPath));
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        if (logger.isDebugEnabled()) {
            session.setTransferListener((org.sonatype.aether.transfer.TransferListener)new TransferListener());
            session.setRepositoryListener((org.sonatype.aether.RepositoryListener)new RepositoryListener());
        }
        return session;
    }

    static String resolveLocalRepoPath(String localRepoPath) {
        String home = System.getenv("ZEPPELIN_HOME");
        if (home == null) {
            home = System.getProperty("zeppelin.home");
        }
        if (home == null) {
            home = "..";
        }
        return Paths.get(home, new String[0]).resolve(localRepoPath).toAbsolutePath().toString();
    }

    public static RemoteRepository newCentralRepository() {
        String mvnRepo = System.getenv("ZEPPELIN_INTERPRETER_DEP_MVNREPO");
        if (mvnRepo == null) {
            mvnRepo = System.getProperty("zeppelin.interpreter.dep.mvnRepo");
        }
        if (mvnRepo == null) {
            mvnRepo = "https://repo1.maven.org/maven2/";
        }
        return new RemoteRepository("central", "default", mvnRepo);
    }

    public static RemoteRepository newLocalRepository() {
        return new RemoteRepository("local", "default", "file://" + System.getProperty("user.home") + "/.m2/repository");
    }
}

