/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.r.RInterpreter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RInterpreterTest {
    private RInterpreter rInterpreter;

    RInterpreterTest() {
    }

    @BeforeEach
    public void setUp() throws InterpreterException {
        Properties properties = new Properties();
        properties.setProperty("zeppelin.R.knitr", "true");
        properties.setProperty("spark.r.backendConnectionTimeout", "10");
        InterpreterContext context = this.getInterpreterContext();
        InterpreterContext.set((InterpreterContext)context);
        this.rInterpreter = new RInterpreter(properties);
        InterpreterGroup interpreterGroup = new InterpreterGroup();
        interpreterGroup.addInterpreterToSession((Interpreter)new LazyOpenInterpreter((Interpreter)this.rInterpreter), "session_1");
        this.rInterpreter.setInterpreterGroup(interpreterGroup);
        this.rInterpreter.open();
    }

    @AfterEach
    public void tearDown() throws InterpreterException {
        this.rInterpreter.close();
    }

    @Test
    void testSparkRInterpreter() throws InterpreterException, InterruptedException, IOException {
        InterpreterResult result = this.rInterpreter.interpret("1+1", this.getInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)result.message().get(0)).getData().contains("2"));
        InterpreterContext context = this.getInterpreterContext();
        result = this.rInterpreter.interpret("foo <- TRUE\nprint(foo)\nbare <- c(1, 2.5, 4)\nprint(bare)\ndouble <- 15.0\nprint(double)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)result.message().get(0)).getData().contains("[1] TRUE\n[1] 1.0 2.5 4.0\n[1] 15\n"), (String)result.toString());
        context = this.getInterpreterContext();
        context.getLocalProperties().put("imageWidth", "100");
        result = this.rInterpreter.interpret("hist(mtcars$mpg)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assertions.assertEquals((int)1, (int)result.message().size());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)result.message().get(0)).getType());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)result.message().get(0)).getData().contains("<img src="));
        Assertions.assertTrue((boolean)((InterpreterResultMessage)result.message().get(0)).getData().contains("width=\"100\""));
        result = this.rInterpreter.interpret("library(ggplot2)\nggplot(diamonds, aes(x=carat, y=price, color=cut)) + geom_point()", this.getInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assertions.assertEquals((int)1, (int)result.message().size());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)result.message().get(0)).getType());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)result.message().get(0)).getData().contains("<img src="));
        Thread.sleep(15000L);
        result = this.rInterpreter.interpret("1+1", this.getInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)result.message().get(0)).getData().contains("sparkR backend is dead"));
    }

    @Test
    void testInvalidR() throws InterpreterException {
        this.tearDown();
        Properties properties = new Properties();
        properties.setProperty("zeppelin.R.cmd", "invalid_r");
        properties.setProperty("spark.master", "local");
        properties.setProperty("spark.app.name", "test");
        InterpreterGroup interpreterGroup = new InterpreterGroup();
        LazyOpenInterpreter rInterpreter = new LazyOpenInterpreter((Interpreter)new RInterpreter(properties));
        interpreterGroup.addInterpreterToSession((Interpreter)rInterpreter, "session_1");
        rInterpreter.setInterpreterGroup(interpreterGroup);
        InterpreterContext context = this.getInterpreterContext();
        InterpreterContext.set((InterpreterContext)context);
        try {
            rInterpreter.interpret("1+1", this.getInterpreterContext());
            Assertions.fail((String)"Should fail to open SparkRInterpreter");
        }
        catch (InterpreterException e) {
            String stacktrace = ExceptionUtils.getStackTrace((Throwable)e);
            Assertions.assertTrue((boolean)stacktrace.contains("No such file or directory"), (String)stacktrace);
        }
    }

    private InterpreterContext getInterpreterContext() {
        InterpreterContext context = InterpreterContext.builder().setNoteId("note_1").setParagraphId("paragraph_1").setInterpreterOut(new InterpreterOutput()).setLocalProperties(new HashMap()).build();
        return context;
    }
}

