/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFImageXObject;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.ImageRenderedAdapter;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFImageHandler;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;

public class PDFImageHandlerRenderedImage
implements PDFImageHandler,
ImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE};

    public PDFXObject generateImage(RendererContext context, Image image, Point origin, Rectangle pos) throws IOException {
        PDFRenderer renderer = (PDFRenderer)context.getRenderer();
        ImageRendered imageRend = (ImageRendered)image;
        PDFDocument pdfDoc = (PDFDocument)context.getProperty("pdfDoc");
        PDFResourceContext resContext = (PDFResourceContext)context.getProperty("pdfContext");
        ImageRenderedAdapter pdfimage = new ImageRenderedAdapter(imageRend, image.getInfo().getOriginalURI());
        PDFImageXObject xobj = pdfDoc.addImage(resContext, pdfimage);
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        renderer.placeImage(x, y, w, h, xobj);
        return xobj;
    }

    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        PDFRenderingContext pdfContext = (PDFRenderingContext)context;
        PDFContentGenerator generator = pdfContext.getGenerator();
        ImageRendered imageRend = (ImageRendered)image;
        ImageRenderedAdapter pdfimage = new ImageRenderedAdapter(imageRend, image.getInfo().getOriginalURI());
        PDFImageXObject xobj = generator.getDocument().addImage(generator.getResourceContext(), pdfimage);
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        generator.placeImage(x, y, w, h, xobj);
    }

    public int getPriority() {
        return 300;
    }

    public Class getSupportedImageClass() {
        return ImageRendered.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext targetContext, Image image) {
        return (image == null || image instanceof ImageRendered) && targetContext instanceof PDFRenderingContext;
    }
}

