/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.extensions.xmp.XMPMetadata;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.render.intermediate.AbstractBinaryWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFDocumentNavigationHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFDocumentNavigationHandler;
import org.apache.fop.render.pdf.PDFPainter;
import org.apache.fop.render.pdf.PDFRendererConfigurator;
import org.apache.fop.render.pdf.PDFRenderingUtil;
import org.apache.xmlgraphics.xmp.Metadata;

public class PDFDocumentHandler
extends AbstractBinaryWritingIFDocumentHandler {
    private static Log log = LogFactory.getLog((Class)PDFDocumentHandler.class);
    protected PDFDocument pdfDoc;
    protected PDFRenderingUtil pdfUtil;
    protected PDFResources pdfResources;
    protected PDFContentGenerator generator;
    protected PDFResourceContext currentContext;
    protected PDFPage currentPage;
    protected PageReference currentPageRef;
    protected Map pageReferences = new HashMap();
    private PDFDocumentNavigationHandler documentNavigationHandler = new PDFDocumentNavigationHandler(this);

    public boolean supportsPagesOutOfOrder() {
        return true;
    }

    public String getMimeType() {
        return "application/pdf";
    }

    public void setContext(IFContext context) {
        super.setContext(context);
        this.pdfUtil = new PDFRenderingUtil(context.getUserAgent());
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        return new PDFRendererConfigurator(this.getUserAgent());
    }

    public IFDocumentNavigationHandler getDocumentNavigationHandler() {
        return this.documentNavigationHandler;
    }

    PDFRenderingUtil getPDFUtil() {
        return this.pdfUtil;
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.pdfDoc = this.pdfUtil.setupPDFDocument(this.outputStream);
        }
        catch (IOException e) {
            throw new IFException("I/O error in startDocument()", e);
        }
    }

    public void endDocumentHeader() throws IFException {
        this.pdfUtil.generateDefaultXMPMetadata();
    }

    public void endDocument() throws IFException {
        try {
            this.pdfDoc.getResources().addFonts(this.pdfDoc, this.fontInfo);
            this.pdfDoc.outputTrailer(this.outputStream);
            this.pdfDoc = null;
            this.pdfResources = null;
            this.generator = null;
            this.currentContext = null;
            this.currentPage = null;
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in endDocument()", ioe);
        }
        super.endDocument();
    }

    public void startPageSequence(String id) throws IFException {
    }

    public void endPageSequence() throws IFException {
    }

    public void startPage(int index, String name, String pageMasterName, Dimension size) throws IFException {
        this.pdfResources = this.pdfDoc.getResources();
        this.currentPage = this.pdfDoc.getFactory().makePage(this.pdfResources, (int)Math.round(size.getWidth() / 1000.0), (int)Math.round(size.getHeight() / 1000.0), index);
        this.pdfUtil.generatePageLabel(index, name);
        this.currentPageRef = new PageReference(this.currentPage, size);
        this.pageReferences.put(new Integer(index), this.currentPageRef);
        this.generator = new PDFContentGenerator(this.pdfDoc, this.outputStream, this.currentPage);
        AffineTransform basicPageTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, (float)size.height / 1000.0f);
        this.generator.concatenate(basicPageTransform);
    }

    public IFPainter startPageContent() throws IFException {
        return new PDFPainter(this);
    }

    public void endPageContent() throws IFException {
    }

    public void endPage() throws IFException {
        try {
            this.documentNavigationHandler.commit();
            this.pdfDoc.registerObject(this.generator.getStream());
            this.currentPage.setContents(this.generator.getStream());
            PDFAnnotList annots = this.currentPage.getAnnotations();
            if (annots != null) {
                this.pdfDoc.addObject(annots);
            }
            this.pdfDoc.addObject(this.currentPage);
            this.generator.flushPDFDoc();
            this.generator = null;
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in endPage()", ioe);
        }
    }

    public void handleExtensionObject(Object extension) throws IFException {
        if (extension instanceof XMPMetadata) {
            this.pdfUtil.renderXMPMetadata((XMPMetadata)extension);
        } else if (extension instanceof Metadata) {
            XMPMetadata wrapper = new XMPMetadata((Metadata)extension);
            this.pdfUtil.renderXMPMetadata(wrapper);
        } else {
            log.debug((Object)("Don't know how to handle extension object. Ignoring: " + extension + " (" + extension.getClass().getName() + ")"));
        }
    }

    PageReference getPageReference(int pageIndex) {
        return (PageReference)this.pageReferences.get(new Integer(pageIndex));
    }

    static final class PageReference {
        private PDFReference pageRef;
        private Dimension pageDimension;

        private PageReference(PDFPage page, Dimension dim) {
            this.pageRef = page.makeReference();
            this.pageDimension = new Dimension(dim);
        }

        public PDFReference getPageRef() {
            return this.pageRef;
        }

        public Dimension getPageDimension() {
            return this.pageDimension;
        }
    }
}

