/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.util.Matrix;

public class PatternUtil {
    private List<COSName> patternNames = new ArrayList<COSName>();
    private PDFPage targetPage;
    private Rectangle pos;
    private PDPage sourcePage;

    public PatternUtil(PDFPage targetPage, Rectangle pos, PDPage sourcePage) throws IOException {
        this.targetPage = targetPage;
        this.pos = pos;
        this.sourcePage = sourcePage;
        PDResources srcPgResources = sourcePage.getResources();
        if (srcPgResources != null) {
            for (COSName name : srcPgResources.getPatternNames()) {
                this.patternNames.add(name);
            }
            this.transformPatterns();
        }
    }

    private void transformPatterns() throws IOException {
        AffineTransform shadingAdjust = this.getShadingAffineTransform();
        PDResources srcPgResources = this.sourcePage.getResources();
        for (COSName srcPgPatternName : this.patternNames) {
            PDAbstractPattern srcPattern = srcPgResources.getPattern(srcPgPatternName);
            Matrix originalMatrix = srcPattern.getMatrix();
            if (originalMatrix == null) {
                originalMatrix = new Matrix();
            }
            Matrix shadingMatrix = new Matrix(shadingAdjust);
            Matrix newMatrix = originalMatrix.multiply(shadingMatrix);
            srcPattern.setMatrix(newMatrix.createAffineTransform());
            srcPgResources.put(srcPgPatternName, srcPattern);
        }
    }

    public List<COSName> getPatternNames() {
        return this.patternNames;
    }

    private AffineTransform getShadingAffineTransform() {
        PDRectangle srcMediaBox = this.sourcePage.getMediaBox();
        PDFArray targetPageMediaBox = (PDFArray)this.targetPage.get("MediaBox");
        double targetMediaBoxHeight = (Double)targetPageMediaBox.get(3);
        Rectangle cDestRect = new Rectangle(this.pos);
        cDestRect.y = (int)(targetMediaBoxHeight * 1000.0 - (this.pos.getY() + this.pos.getHeight()));
        double xScaleFactor = cDestRect.getWidth() / 1000.0 / (double)srcMediaBox.getWidth();
        double yScaleFactor = cDestRect.getHeight() / 1000.0 / (double)srcMediaBox.getHeight();
        double xTranslation = cDestRect.getX() / 1000.0 - (double)srcMediaBox.getLowerLeftX() * xScaleFactor;
        double yTranslation = cDestRect.getY() / 1000.0 - (double)srcMediaBox.getLowerLeftY() * yScaleFactor;
        return new AffineTransform(xScaleFactor, 0.0, 0.0, yScaleFactor, xTranslation, yTranslation);
    }

    public void promotePatterns() {
        PDFDictionary patternsDict = (PDFDictionary)this.targetPage.getPDFResources().get(COSName.PATTERN.getName());
        if (patternsDict != null) {
            for (String key : patternsDict.keySet()) {
                PDFObject pattern = (PDFObject)patternsDict.get(key);
                pattern.setObjectNumber(this.targetPage.getDocument());
                this.targetPage.getDocument().addObject(pattern);
            }
        }
    }

    public String getKey(String key) {
        if (this.patternNames.isEmpty()) {
            return key;
        }
        return key + this.pos.getX() + this.pos.getY() + this.pos.getWidth() + this.pos.getHeight();
    }
}

