/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.render.pdf.pdfbox.HandleAnnotations;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapter;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public class MergeAnnotations
implements HandleAnnotations<Object> {
    private PDFBoxAdapter pdfBoxAdapter;
    private Map<String, Object> fields;

    public MergeAnnotations(PDFBoxAdapter pdfBoxAdapter, Map<String, Object> fields) {
        this.pdfBoxAdapter = pdfBoxAdapter;
        this.fields = fields;
    }

    @Override
    public Set<Object> getFields() {
        return new HashSet<Object>(this.fields.values());
    }

    @Override
    public void load(COSObject annot, PDAcroForm srcAcroForm) {
    }

    @Override
    public void cloneAnnotParent(COSBase annot, PDFDictionary clonedAnnot, Collection<COSName> exclude) throws IOException {
        if (clonedAnnot.containsKey("T")) {
            ArrayList<String> nameList = new ArrayList<String>();
            this.addToTree(clonedAnnot, nameList);
            PDFDictionary node = (PDFDictionary)this.fields.get(nameList.remove(0));
            while (!nameList.isEmpty()) {
                String name = (String)nameList.remove(0);
                PDFDictionary nextNode = this.findKid(name, node);
                if (nextNode == null) {
                    if (nameList.isEmpty()) {
                        nextNode = node;
                    } else {
                        nextNode = new PDFDictionary();
                        this.pdfBoxAdapter.pdfDoc.registerTrailerObject((PDFObject)nextNode);
                        nextNode.put("Kids", (Object)new PDFArray());
                        nextNode.put("T", (Object)name);
                        nextNode.put("Parent", (Object)node);
                        PDFArray kids = (PDFArray)node.get("Kids");
                        kids.add((Object)nextNode);
                    }
                }
                node = nextNode;
            }
            if (node != clonedAnnot) {
                this.insert(node, clonedAnnot);
            }
        }
    }

    private void insert(PDFDictionary parent, PDFDictionary clonedAnnot) throws IOException {
        if (parent.containsKey("Kids")) {
            PDFArray kids = (PDFArray)parent.get("Kids");
            kids.add((Object)clonedAnnot);
        } else {
            PDFDictionary grandParent = (PDFDictionary)parent.get("Parent");
            PDFDictionary child = parent;
            parent = new PDFDictionary();
            if (grandParent != null) {
                PDFArray kids = (PDFArray)grandParent.get("Kids");
                kids.add((Object)parent);
            }
            this.pdfBoxAdapter.pdfDoc.registerTrailerObject((PDFObject)parent);
            List<String> excludeCopy = Arrays.asList("Subtype", "Type", "Rect", "MK", "F");
            for (String key : child.keySet()) {
                if (excludeCopy.contains(key)) continue;
                parent.put(key, child.get(key));
            }
            child.remove("T");
            child.put("Parent", (Object)parent);
            parent.put("Kids", (Object)new PDFArray(new Object[]{clonedAnnot, child}));
        }
        if (this.getT(clonedAnnot).equals(this.getT(parent))) {
            clonedAnnot.remove("T");
        }
        clonedAnnot.put("Parent", (Object)parent);
    }

    private PDFDictionary findKid(String name, PDFDictionary node) throws IOException {
        PDFArray kids = (PDFArray)node.get("Kids");
        for (int i = 0; i < kids.length(); ++i) {
            PDFDictionary kid = (PDFDictionary)kids.get(i);
            if (!name.equals(this.getT(kid))) continue;
            return kid;
        }
        return null;
    }

    private void addToTree(PDFDictionary clonedAnnot, List<String> nameList) throws IOException {
        String tStr = this.getT(clonedAnnot);
        nameList.add(0, tStr);
        Object parent = clonedAnnot.get("Parent");
        if (parent instanceof PDFDictionary) {
            this.addToTree((PDFDictionary)parent, nameList);
        } else if (!this.fields.containsKey(tStr)) {
            this.fields.put(tStr, clonedAnnot);
        }
    }

    private String getT(PDFDictionary clonedAnnot) throws IOException {
        Object tStr = clonedAnnot.get("T");
        if (tStr instanceof byte[]) {
            tStr = new String((byte[])tStr, "ISO-8859-1");
        }
        return (String)tStr;
    }
}

