/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;

public class UniqueName {
    private String key;
    private List<COSName> resourceNames;

    public UniqueName(String key, COSDictionary sourcePageResources) {
        this.key = Integer.toString(key.hashCode());
        this.resourceNames = this.getResourceNames(sourcePageResources);
    }

    protected String getName(COSName cn) {
        if (this.resourceNames.contains(cn)) {
            return cn.getName() + this.key;
        }
        return cn.getName();
    }

    private List<COSName> getResourceNames(COSDictionary sourcePageResources) {
        ArrayList<COSName> resourceNames = new ArrayList<COSName>();
        for (COSBase e : sourcePageResources.getValues()) {
            if (e instanceof COSObject) {
                e = ((COSObject)e).getObject();
            }
            if (!(e instanceof COSDictionary)) continue;
            COSDictionary d = (COSDictionary)e;
            resourceNames.addAll(d.keySet());
        }
        return resourceNames;
    }
}

