/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.fop.render.pdf.pdfbox.UniqueName;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class PDFWriter {
    private DecimalFormat df = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.US));
    private Map<Float, String> floatCache = new HashMap<Float, String>();
    protected StringBuilder s = new StringBuilder();
    protected UniqueName key;
    private int currentMCID;

    public PDFWriter(UniqueName key, int currentMCID) {
        this.key = key;
        this.currentMCID = currentMCID;
    }

    public String writeText(PDStream pdStream) throws IOException {
        PDFStreamParser pdfStreamParser = new PDFStreamParser(pdStream);
        pdfStreamParser.parse();
        List it = pdfStreamParser.getTokens();
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        for (Object o : it) {
            if (o instanceof Operator) {
                Operator op = (Operator)o;
                this.readPDFArguments(op, arguments);
                this.s.append(op.getName() + "\n");
                arguments.clear();
                if (op.getImageParameters() == null) continue;
                for (Map.Entry cn : op.getImageParameters().entrySet()) {
                    arguments.add((COSBase)cn.getKey());
                    arguments.add((COSBase)cn.getValue());
                }
                this.readPDFArguments(op, arguments);
                this.s.append("ID " + new String(op.getImageData(), "ISO-8859-1"));
                arguments.clear();
                this.s.append("EI\n");
                continue;
            }
            arguments.add((COSBase)o);
        }
        return this.s.toString();
    }

    protected void readPDFArguments(Operator op, Collection<COSBase> arguments) throws IOException {
        for (COSBase c : arguments) {
            this.processArg(op, c);
        }
    }

    protected void processArg(Operator op, COSBase c) throws IOException {
        if (c instanceof COSInteger) {
            this.s.append(((COSInteger)c).intValue());
            this.s.append(" ");
        } else if (c instanceof COSFloat) {
            float f = ((COSFloat)c).floatValue();
            if (!this.floatCache.containsKey(Float.valueOf(f))) {
                this.addCache(f);
            }
            this.s.append(this.floatCache.get(Float.valueOf(f)));
            this.s.append(" ");
            if (this.floatCache.size() > 1024) {
                this.floatCache.clear();
            }
        } else if (c instanceof COSName) {
            COSName cn = (COSName)c;
            this.s.append("/" + this.key.getName(cn));
            this.s.append(" ");
        } else if (c instanceof COSString) {
            this.s.append("<" + ((COSString)c).toHexString() + ">");
        } else if (c instanceof COSArray) {
            this.s.append("[");
            this.readPDFArguments(op, ((COSArray)c).toList());
            this.s.append("] ");
        } else if (c instanceof COSDictionary) {
            ArrayList<COSBase> dictArgs = new ArrayList<COSBase>();
            if (this.currentMCID != 0 && op.getName().equals("BDC")) {
                for (Map.Entry cn : ((COSDictionary)c).entrySet()) {
                    if (((COSName)cn.getKey()).getName().equals("MCID")) {
                        this.updateMCID(cn, dictArgs);
                        continue;
                    }
                    dictArgs.add((COSBase)cn.getKey());
                    dictArgs.add((COSBase)cn.getValue());
                }
            } else {
                for (Map.Entry cn : ((COSDictionary)c).entrySet()) {
                    dictArgs.add((COSBase)cn.getKey());
                    dictArgs.add((COSBase)cn.getValue());
                }
            }
            this.s.append("<<");
            this.readPDFArguments(op, dictArgs);
            this.s.append(">>");
        } else if (c instanceof COSBoolean) {
            this.s.append(((COSBoolean)c).getValue());
        } else {
            throw new IOException(c + " not supported");
        }
    }

    protected void addCache(float f) {
        String formatted = this.df.format(f);
        this.floatCache.put(Float.valueOf(f), formatted);
    }

    private void updateMCID(Map.Entry<COSName, COSBase> cn, Collection<COSBase> dictArgs) {
        COSBase cosMCID = cn.getValue();
        assert (cosMCID instanceof COSInteger);
        COSInteger mcid = (COSInteger)cosMCID;
        COSInteger updatedID = COSInteger.get((long)(mcid.intValue() + this.currentMCID));
        dictArgs.add((COSBase)cn.getKey());
        dictArgs.add((COSBase)updatedID);
    }

    protected int getCurrentMCID() {
        return this.currentMCID;
    }
}

