/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PDFBoxAdapterUtil {
    private PDFBoxAdapterUtil() {
    }

    private static Integer getStreamHash(COSStream o) throws IOException {
        for (COSBase x : o.getValues()) {
            if (!(x instanceof COSObject) && !(x instanceof COSDictionary)) continue;
            return null;
        }
        InputStream stream = o.getFilteredStream();
        byte[] b = IOUtils.toByteArray((InputStream)stream);
        return Arrays.deepHashCode(new Object[]{b, o.toString()});
    }

    private static String getDictionaryHash(COSBase base) throws IOException {
        return PDFBoxAdapterUtil.getDictionaryHash(base, new ArrayList<COSBase>());
    }

    private static String getDictionaryHash(COSBase base, List<COSBase> objs) throws IOException {
        if (base == null) {
            return "null";
        }
        if (objs.contains(base)) {
            return String.valueOf(base.hashCode());
        }
        objs.add(base);
        if (base instanceof COSDictionary) {
            StringBuilder sb = new StringBuilder();
            sb.append("COSDictionary{");
            for (Map.Entry x : ((COSDictionary)base).entrySet()) {
                sb.append(x.getKey());
                sb.append(":");
                sb.append(PDFBoxAdapterUtil.getDictionaryHash((COSBase)x.getValue(), objs));
                sb.append(";");
            }
            sb.append("}");
            if (base instanceof COSStream) {
                InputStream stream = ((COSStream)base).getFilteredStream();
                byte[] b = IOUtils.toByteArray((InputStream)stream);
                sb.append("COSStream{").append(Arrays.hashCode(b)).append("}");
            }
            return sb.toString();
        }
        if (base instanceof COSObject) {
            COSObject obj = (COSObject)base;
            return "COSObject{" + PDFBoxAdapterUtil.getDictionaryHash(obj.getObject(), objs) + "}";
        }
        return base.toString();
    }

    protected static Object getBaseKey(Object base) throws IOException {
        if (base instanceof COSObject) {
            Integer hash;
            COSObject obj = (COSObject)base;
            COSBase o = obj.getObject();
            if (o instanceof COSStream && (hash = PDFBoxAdapterUtil.getStreamHash((COSStream)o)) != null) {
                return hash;
            }
            return obj.getObjectNumber() + " " + obj.getGenerationNumber();
        }
        if (base instanceof COSDictionary) {
            String dict = PDFBoxAdapterUtil.getDictionaryHash((COSBase)base);
            return String.valueOf(dict.hashCode());
        }
        return null;
    }

    protected static void rotate(int rotation, PDRectangle viewBox, AffineTransform atdoc) {
        float w = viewBox.getWidth();
        float h = viewBox.getHeight();
        float x = viewBox.getLowerLeftX();
        float y = viewBox.getLowerLeftY();
        switch (rotation) {
            case 90: {
                atdoc.rotate(Math.toRadians(rotation + 180), x, y);
                atdoc.translate(-h, 0.0);
                break;
            }
            case 180: {
                atdoc.translate(w, h);
                atdoc.rotate(Math.toRadians(rotation), x, y);
                break;
            }
            case 270: {
                atdoc.rotate(Math.toRadians(rotation + 180), x, h + y);
                atdoc.translate(-w, 0.0);
                break;
            }
        }
    }

    protected static void updateAnnotationLink(PDFDictionary clonedAnnot) {
        PDFArray oldarray;
        Object newarrayObj;
        PDFDictionary annot;
        Object oldarrayObj;
        Object a = clonedAnnot.get("A");
        if (a instanceof PDFDictionary && (oldarrayObj = (annot = (PDFDictionary)a).get("D")) instanceof PDFArray && (newarrayObj = (oldarray = (PDFArray)oldarrayObj).get(0)) instanceof PDFArray) {
            PDFArray newarray = (PDFArray)newarrayObj;
            for (int i = 1; i < oldarray.length(); ++i) {
                newarray.add(oldarray.get(i));
            }
            annot.put("D", oldarray.get(0));
        }
    }

    protected static void moveAnnotations(PDPage page, List pageAnnotations, AffineTransform at) {
        PDRectangle mediaBox = page.getMediaBox();
        PDRectangle cropBox = page.getCropBox();
        PDRectangle viewBox = cropBox != null ? cropBox : mediaBox;
        for (Object obj : pageAnnotations) {
            PDAnnotation annot = (PDAnnotation)obj;
            PDRectangle rect = annot.getRectangle();
            float translateX = (float)(at.getTranslateX() - (double)viewBox.getLowerLeftX());
            float translateY = (float)(at.getTranslateY() - (double)viewBox.getLowerLeftY());
            if (rect == null) continue;
            rect.setUpperRightX(rect.getUpperRightX() + translateX);
            rect.setLowerLeftX(rect.getLowerLeftX() + translateX);
            rect.setUpperRightY(rect.getUpperRightY() + translateY);
            rect.setLowerLeftY(rect.getLowerLeftY() + translateY);
            annot.setRectangle(rect);
        }
    }
}

