/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.pdfbox.FOPPDFFont;
import org.apache.fop.render.pdf.pdfbox.MergeFontsPDFWriter;
import org.apache.fop.render.pdf.pdfbox.PDFBoolean;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapterUtil;
import org.apache.fop.render.pdf.pdfbox.PDFString;
import org.apache.fop.render.pdf.pdfbox.PDFUtil;
import org.apache.fop.render.pdf.pdfbox.PDFWriter;
import org.apache.fop.render.pdf.pdfbox.UniqueName;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFBoxAdapter {
    protected static final Log log = LogFactory.getLog(PDFBoxAdapter.class);
    private static final Set FILTER_FILTER = new HashSet<String>(Arrays.asList("Filter", "DecodeParms"));
    private final PDFPage targetPage;
    private final PDFDocument pdfDoc;
    private final Map<Object, Object> clonedVersion;
    private final Map<Object, Object> objectCache;
    private Map<COSName, String> newXObj = new HashMap<COSName, String>();
    private Map<Integer, PDFArray> pageNumbers;
    private Collection<String> parentFonts = new ArrayList<String>();
    private int currentMCID;

    public PDFBoxAdapter(PDFPage targetPage, Map<Object, Object> objectCachePerFile, Map<Integer, PDFArray> pageNumbers) {
        this(targetPage, objectCachePerFile, pageNumbers, new HashMap<Object, Object>());
    }

    public PDFBoxAdapter(PDFPage targetPage, Map<Object, Object> objectCachePerFile, Map<Integer, PDFArray> pageNumbers, Map<Object, Object> objectCache) {
        this.targetPage = targetPage;
        this.pdfDoc = this.targetPage.getDocument();
        this.clonedVersion = objectCachePerFile;
        this.pageNumbers = pageNumbers;
        this.objectCache = objectCache;
    }

    public PDFPage getTargetPage() {
        return this.targetPage;
    }

    public int getCurrentMCID() {
        return this.currentMCID;
    }

    public void setCurrentMCID(int currentMCID) {
        this.currentMCID = currentMCID;
    }

    protected Object cloneForNewDocument(Object base) throws IOException {
        return this.cloneForNewDocument(base, base);
    }

    protected Object cloneForNewDocument(Object base, Object keyBase) throws IOException {
        return this.cloneForNewDocument(base, keyBase, Collections.EMPTY_LIST);
    }

    protected Object cloneForNewDocument(Object base, Object keyBase, Collection exclude) throws IOException {
        if (base == null) {
            return null;
        }
        Object cached = this.getCachedClone(keyBase);
        if (cached != null) {
            return cached;
        }
        if (base instanceof List) {
            PDFArray array = new PDFArray();
            this.cacheClonedObject(keyBase, array);
            List list = (List)base;
            for (Object o : list) {
                array.add(this.cloneForNewDocument(o, o, exclude));
            }
            return array;
        }
        if (base instanceof COSObjectable && !(base instanceof COSBase)) {
            COSBase o = ((COSObjectable)base).getCOSObject();
            Object retval = this.cloneForNewDocument(o, o, exclude);
            return this.cacheClonedObject(keyBase, retval);
        }
        if (base instanceof COSObject) {
            return this.readCOSObject((COSObject)base, exclude);
        }
        if (base instanceof COSArray) {
            PDFArray newArray = new PDFArray();
            this.cacheClonedObject(keyBase, newArray);
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                newArray.add(this.cloneForNewDocument(array.get(i), array.get(i), exclude));
            }
            return newArray;
        }
        if (base instanceof COSStream) {
            return this.readCOSStream((COSStream)base, keyBase);
        }
        if (base instanceof COSDictionary) {
            return this.readCOSDictionary((COSDictionary)base, keyBase, exclude);
        }
        if (base instanceof COSName) {
            byte[] name = ((COSName)base).getName().getBytes("ISO-8859-1");
            PDFName newName = new PDFName(new String(name, "ISO-8859-1"));
            return this.cacheClonedObject(keyBase, newName);
        }
        if (base instanceof COSInteger) {
            PDFNumber number = new PDFNumber();
            number.setNumber((Number)((COSInteger)base).longValue());
            return this.cacheClonedObject(keyBase, number);
        }
        if (base instanceof COSFloat) {
            PDFNumber number = new PDFNumber();
            number.setNumber((Number)Float.valueOf(((COSFloat)base).floatValue()));
            return this.cacheClonedObject(keyBase, number);
        }
        if (base instanceof COSBoolean) {
            Boolean retval = ((COSBoolean)base).getValueAsObject();
            if (keyBase instanceof COSObject) {
                return this.cacheClonedObject(keyBase, (Object)new PDFBoolean(retval));
            }
            return this.cacheClonedObject(keyBase, retval);
        }
        if (base instanceof COSString) {
            return this.readCOSString((COSString)base, keyBase);
        }
        if (base instanceof COSNull) {
            return this.cacheClonedObject(keyBase, null);
        }
        throw new UnsupportedOperationException("NYI: " + base.getClass().getName());
    }

    private PDFDictionary readCOSDictionary(COSDictionary dic, Object keyBase, Collection exclude) throws IOException {
        PDFDictionary newDict = new PDFDictionary();
        this.cacheClonedObject(keyBase, newDict);
        for (Map.Entry e : dic.entrySet()) {
            if (exclude.contains(e.getKey())) continue;
            newDict.put(((COSName)e.getKey()).getName(), this.cloneForNewDocument(e.getValue(), e.getValue(), exclude));
        }
        return newDict;
    }

    private Object readCOSObject(COSObject object, Collection exclude) throws IOException {
        Object obj;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cloning indirect object: " + object.getObjectNumber() + " " + object.getGenerationNumber()));
        }
        if ((obj = this.cloneForNewDocument(object.getObject(), object, exclude)) instanceof PDFObject) {
            PDFObject pdfobj = (PDFObject)obj;
            if (!pdfobj.hasObjectNumber()) {
                throw new IllegalStateException("PDF object was not registered!");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Object registered: " + pdfobj.getObjectNumber() + " " + pdfobj.getGeneration() + " for COSObject: " + object.getObjectNumber() + " " + object.getGenerationNumber()));
            }
        }
        return obj;
    }

    private Object readCOSString(COSString string, Object keyBase) throws IOException {
        byte[] bytes = string.getBytes();
        if (keyBase instanceof COSObject) {
            return this.cacheClonedObject(keyBase, (Object)new PDFString(bytes));
        }
        if (PDFString.isUSASCII(bytes)) {
            return this.cacheClonedObject(keyBase, string.getString());
        }
        return this.cacheClonedObject(keyBase, bytes);
    }

    private Object readCOSStream(COSStream originalStream, Object keyBase) throws IOException {
        Set filter;
        InputStream in;
        if (this.pdfDoc.isEncryptionActive() || originalStream.containsKey(COSName.DECODE_PARMS) && !originalStream.containsKey(COSName.FILTER)) {
            in = originalStream.getUnfilteredStream();
            filter = FILTER_FILTER;
        } else {
            in = originalStream.getFilteredStream();
            filter = Collections.EMPTY_SET;
        }
        PDFStream stream = new PDFStream();
        OutputStream out = stream.getBufferOutputStream();
        IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        this.transferDict((COSDictionary)originalStream, stream, filter);
        return this.cacheClonedObject(keyBase, stream);
    }

    protected Object getCachedClone(Object base) throws IOException {
        Object key = PDFBoxAdapterUtil.getBaseKey(base);
        Object o = this.clonedVersion.get(key);
        if (o == null) {
            return this.objectCache.get(key);
        }
        return o;
    }

    protected Object cacheClonedObject(Object base, Object cloned) throws IOException {
        Object key = PDFBoxAdapterUtil.getBaseKey(base);
        if (key == null) {
            return cloned;
        }
        PDFObject pdfobj = (PDFObject)cloned;
        if (pdfobj != null && !pdfobj.hasObjectNumber() && !(base instanceof COSDictionary)) {
            this.pdfDoc.registerObject(pdfobj);
            if (log.isTraceEnabled()) {
                log.trace((Object)(key + ": " + pdfobj.getClass().getName() + " registered as " + pdfobj.getObjectNumber() + " " + pdfobj.getGeneration()));
            }
        }
        this.clonedVersion.put(key, cloned);
        if (key instanceof Integer) {
            this.objectCache.put(key, cloned);
        }
        return cloned;
    }

    private void transferDict(COSDictionary orgDict, PDFStream targetDict, Set filter) throws IOException {
        this.transferDict(orgDict, targetDict, filter, false);
    }

    private void transferDict(COSDictionary orgDict, PDFStream targetDict, Set filter, boolean inclusive) throws IOException {
        Set keys = orgDict.keySet();
        for (COSName key : keys) {
            if (inclusive && !filter.contains(key.getName()) || !inclusive && filter.contains(key.getName())) continue;
            targetDict.put(key.getName(), this.cloneForNewDocument(orgDict.getItem(key)));
        }
    }

    public String createStreamFromPDFBoxPage(PDDocument sourceDoc, PDPage page, String key, AffineTransform atdoc, FontInfo fontinfo, Rectangle pos) throws IOException {
        this.handleAnnotations(sourceDoc, page, atdoc);
        if (this.pageNumbers.containsKey(this.targetPage.getPageIndex())) {
            this.pageNumbers.get(this.targetPage.getPageIndex()).set(0, (Object)this.targetPage.makeReference());
        }
        COSDictionary sourcePageResources = this.getResources(page);
        PDStream pdStream = this.getContents(page);
        COSDictionary fonts = (COSDictionary)sourcePageResources.getDictionaryObject(COSName.FONT);
        COSDictionary fontsBackup = null;
        UniqueName uniqueName = new UniqueName(key, sourcePageResources);
        String newStream = null;
        if (fonts != null && this.pdfDoc.isMergeFontsEnabled()) {
            fontsBackup = new COSDictionary(fonts);
            MergeFontsPDFWriter m = new MergeFontsPDFWriter(fonts, fontinfo, uniqueName, this.parentFonts, this.currentMCID);
            newStream = m.writeText(pdStream);
        }
        if (newStream == null) {
            PDFWriter writer = new PDFWriter(uniqueName, this.currentMCID);
            newStream = writer.writeText(pdStream);
            this.currentMCID = writer.getCurrentMCID();
        }
        pdStream = new PDStream(sourceDoc, (InputStream)new ByteArrayInputStream(newStream.getBytes("ISO-8859-1")));
        this.mergeXObj(sourcePageResources, fontinfo, uniqueName);
        PDFDictionary pageResources = (PDFDictionary)this.cloneForNewDocument(sourcePageResources);
        PDFDictionary fontDict = (PDFDictionary)pageResources.get("Font");
        if (fontDict != null && this.pdfDoc.isMergeFontsEnabled()) {
            for (Map.Entry fontEntry : fontinfo.getUsedFonts().entrySet()) {
                Typeface font = (Typeface)fontEntry.getValue();
                if (!(font instanceof FOPPDFFont)) continue;
                FOPPDFFont pdfFont = (FOPPDFFont)font;
                if (pdfFont.getRef() == null) {
                    pdfFont.setRef(new PDFDictionary());
                    this.pdfDoc.assignObjectNumber((PDFObject)pdfFont.getRef());
                }
                fontDict.put((String)fontEntry.getKey(), (Object)pdfFont.getRef());
            }
        }
        this.updateXObj(sourcePageResources, pageResources);
        if (fontsBackup != null) {
            sourcePageResources.setItem(COSName.FONT, (COSBase)fontsBackup);
        }
        COSStream originalPageContents = pdStream.getCOSObject();
        this.bindOptionalContent(sourceDoc);
        PDFStream pageStream = (PDFStream)this.cloneForNewDocument(originalPageContents);
        Set filter = Collections.EMPTY_SET;
        if (pageStream == null) {
            pageStream = new PDFStream();
        }
        if (originalPageContents != null) {
            this.transferDict((COSDictionary)originalPageContents, pageStream, filter);
        }
        this.transferPageDict(fonts, uniqueName, sourcePageResources);
        PDRectangle mediaBox = page.getMediaBox();
        PDRectangle cropBox = page.getCropBox();
        PDRectangle viewBox = cropBox != null ? cropBox : mediaBox;
        int rotation = PDFUtil.getNormalizedRotation(page);
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        if (rotation == 90 || rotation == 270) {
            float tmp = w;
            w = h;
            h = tmp;
        }
        atdoc.setTransform(AffineTransform.getScaleInstance(w / viewBox.getWidth(), h / viewBox.getHeight()));
        atdoc.translate(0.0, viewBox.getHeight());
        atdoc.rotate(-Math.PI);
        atdoc.scale(-1.0, 1.0);
        atdoc.translate(-viewBox.getLowerLeftX(), -viewBox.getLowerLeftY());
        PDFBoxAdapterUtil.rotate(rotation, viewBox, atdoc);
        StringBuilder boxStr = new StringBuilder();
        boxStr.append(PDFNumber.doubleOut((double)mediaBox.getLowerLeftX())).append(' ').append(PDFNumber.doubleOut((double)mediaBox.getLowerLeftY())).append(' ').append(PDFNumber.doubleOut((double)mediaBox.getWidth())).append(' ').append(PDFNumber.doubleOut((double)mediaBox.getHeight())).append(" re W n\n");
        return boxStr.toString() + IOUtils.toString((InputStream)pdStream.createInputStream(null), (String)"ISO-8859-1");
    }

    private PDStream getContents(PDPage page) throws IOException {
        PDStream pdStream = new PDStream(new COSStream());
        OutputStream os = pdStream.createOutputStream();
        IOUtils.copy((InputStream)page.getContents(), (OutputStream)os);
        os.close();
        return pdStream;
    }

    private COSDictionary getResources(PDPage page) {
        PDResources res = page.getResources();
        if (res == null) {
            return new COSDictionary();
        }
        return res.getCOSObject();
    }

    private void mergeXObj(COSDictionary sourcePageResources, FontInfo fontinfo, UniqueName uniqueName) throws IOException {
        COSDictionary xobj = (COSDictionary)sourcePageResources.getDictionaryObject(COSName.XOBJECT);
        if (xobj != null && this.pdfDoc.isMergeFontsEnabled()) {
            for (Map.Entry i : xobj.entrySet()) {
                MergeFontsPDFWriter writer;
                String c;
                COSDictionary src;
                COSObject v = (COSObject)i.getValue();
                COSStream stream = (COSStream)v.getObject();
                COSDictionary res = (COSDictionary)stream.getDictionaryObject(COSName.RESOURCES);
                if (res == null || (src = (COSDictionary)res.getDictionaryObject(COSName.FONT)) == null) continue;
                COSDictionary target = (COSDictionary)sourcePageResources.getDictionaryObject(COSName.FONT);
                if (target == null) {
                    sourcePageResources.setItem(COSName.FONT, (COSBase)src);
                } else {
                    for (Map.Entry entry : src.entrySet()) {
                        if (target.keySet().contains(entry.getKey())) continue;
                        target.setItem(uniqueName.getName((COSName)entry.getKey()), (COSBase)entry.getValue());
                    }
                }
                if ((c = ((PDFWriter)(writer = new MergeFontsPDFWriter(src, fontinfo, uniqueName, this.parentFonts, 0))).writeText(new PDStream(stream))) == null) continue;
                stream.removeItem(COSName.FILTER);
                this.newXObj.put((COSName)i.getKey(), c);
                for (Object e : src.keySet().toArray()) {
                    COSName name = (COSName)e;
                    src.setItem(uniqueName.getName(name), src.getItem(name));
                    src.removeItem(name);
                }
            }
        }
    }

    private void updateXObj(COSDictionary sourcePageResources, PDFDictionary pageResources) throws IOException {
        COSDictionary xobj = (COSDictionary)sourcePageResources.getDictionaryObject(COSName.XOBJECT);
        if (xobj != null && this.pdfDoc.isMergeFontsEnabled()) {
            PDFDictionary target = (PDFDictionary)pageResources.get("XObject");
            for (COSName entry : xobj.keySet()) {
                if (!this.newXObj.containsKey(entry)) continue;
                PDFStream s = (PDFStream)target.get(entry.getName());
                s.setData(this.newXObj.get(entry).getBytes("ISO-8859-1"));
                PDFDictionary xobjr = (PDFDictionary)s.get("Resources");
                xobjr.put("Font", pageResources.get("Font"));
            }
        }
    }

    private void transferPageDict(COSDictionary fonts, UniqueName uniqueName, COSDictionary sourcePageResources) throws IOException {
        if (fonts != null) {
            for (Map.Entry f : fonts.entrySet()) {
                String name = uniqueName.getName((COSName)f.getKey());
                this.targetPage.getPDFResources().addFont(name, (PDFDictionary)this.cloneForNewDocument(f.getValue()));
            }
        }
        for (Map.Entry e : sourcePageResources.entrySet()) {
            this.transferDict(e, uniqueName);
        }
    }

    private void transferDict(Map.Entry<COSName, COSBase> dict, UniqueName uniqueName) throws IOException {
        COSBase src = dict.getValue() instanceof COSObject ? ((COSObject)dict.getValue()).getObject() : dict.getValue();
        if (dict.getKey() != COSName.FONT && src instanceof COSDictionary) {
            String name = dict.getKey().getName();
            PDFDictionary newDict = (PDFDictionary)this.targetPage.getPDFResources().get(name);
            if (newDict == null) {
                newDict = new PDFDictionary((PDFObject)this.targetPage.getPDFResources());
            }
            COSDictionary srcDict = (COSDictionary)src;
            for (Map.Entry v : srcDict.entrySet()) {
                newDict.put(uniqueName.getName((COSName)v.getKey()), this.cloneForNewDocument(v.getValue()));
            }
            this.targetPage.getPDFResources().put(name, (Object)newDict);
        }
    }

    private void bindOptionalContent(PDDocument sourceDoc) throws IOException {
    }

    private void handleAnnotations(PDDocument sourceDoc, PDPage page, AffineTransform at) throws IOException {
        PDFArray clonedFields;
        PDDocumentCatalog srcCatalog = sourceDoc.getDocumentCatalog();
        PDAcroForm srcAcroForm = srcCatalog.getAcroForm();
        List pageAnnotations = page.getAnnotations();
        if (srcAcroForm == null && pageAnnotations.isEmpty()) {
            return;
        }
        PDFBoxAdapterUtil.moveAnnotations(page, pageAnnotations, at);
        COSObject cosPage = null;
        COSDictionary parentDic = (COSDictionary)page.getCOSObject().getDictionaryObject(COSName.PARENT, COSName.P);
        COSArray kids = (COSArray)parentDic.getDictionaryObject(COSName.KIDS);
        for (int i = 0; i < kids.size(); ++i) {
            COSObject kid = (COSObject)kids.get(i);
            if (!this.pageNumbers.containsKey(i)) {
                PDFArray a = new PDFArray();
                a.add(null);
                this.pdfDoc.assignObjectNumber((PDFObject)a);
                this.pdfDoc.addTrailerObject((PDFObject)a);
                this.pageNumbers.put(i, a);
            }
            this.cacheClonedObject(kid, this.pageNumbers.get(i));
            if (kid.getObject() != page.getCOSObject()) continue;
            cosPage = kid;
        }
        if (cosPage == null) {
            throw new IOException("Illegal PDF. Page not part of parent page node.");
        }
        Set<COSObject> fields = this.copyAnnotations(page);
        boolean formAlreadyCopied = this.getCachedClone(srcAcroForm) != null;
        PDFRoot catalog = this.pdfDoc.getRoot();
        PDFDictionary destAcroForm = (PDFDictionary)catalog.get(COSName.ACRO_FORM.getName());
        if (!formAlreadyCopied && destAcroForm == null) {
            if (srcAcroForm != null) {
                List<COSName> exclude = Collections.singletonList(COSName.FIELDS);
                destAcroForm = (PDFDictionary)this.cloneForNewDocument(srcAcroForm, srcAcroForm, exclude);
            } else {
                destAcroForm = new PDFDictionary((PDFObject)this.pdfDoc.getRoot());
            }
            this.pdfDoc.assignObjectNumber((PDFObject)destAcroForm);
            this.pdfDoc.addTrailerObject((PDFObject)destAcroForm);
            catalog.put(COSName.ACRO_FORM.getName(), (Object)destAcroForm);
        }
        if ((clonedFields = (PDFArray)destAcroForm.get(COSName.FIELDS.getName())) == null) {
            clonedFields = new PDFArray();
            destAcroForm.put(COSName.FIELDS.getName(), (Object)clonedFields);
        }
        for (COSObject field : fields) {
            PDFDictionary clone = (PDFDictionary)this.cloneForNewDocument(field, field, Arrays.asList(COSName.KIDS));
            clonedFields.add((Object)clone);
        }
    }

    private Set<COSObject> copyAnnotations(PDPage page) throws IOException {
        COSArray annots = (COSArray)page.getCOSObject().getDictionaryObject(COSName.ANNOTS);
        Set<COSObject> fields = Collections.emptySet();
        if (annots != null) {
            fields = new TreeSet<COSObject>(new CompareFields());
            for (COSBase annot1 : annots) {
                PDFObject clonedAnnot;
                ArrayList<COSName> exclude = new ArrayList<COSName>();
                exclude.add(COSName.P);
                if (annot1 instanceof COSObject) {
                    COSObject annot = (COSObject)annot1;
                    this.getField(annot, fields);
                    if (((COSDictionary)annot.getObject()).getItem(COSName.STRUCT_PARENT) != null) {
                        exclude.add(COSName.PARENT);
                    }
                }
                if ((clonedAnnot = (PDFObject)this.cloneForNewDocument(annot1, annot1, exclude)) instanceof PDFDictionary) {
                    clonedAnnot.setParent((PDFObject)this.targetPage);
                    PDFBoxAdapterUtil.updateAnnotationLink((PDFDictionary)clonedAnnot);
                }
                this.targetPage.addAnnotation(clonedAnnot);
            }
        }
        return fields;
    }

    private COSDictionary getField(COSObject fieldObject, Set<COSObject> fields) {
        COSObject parent;
        COSDictionary field = (COSDictionary)fieldObject.getObject();
        while ((parent = this.getParent(field)) != null) {
            fieldObject = parent;
            field = (COSDictionary)fieldObject.getObject();
        }
        fields.add(fieldObject);
        return field;
    }

    private COSObject getParent(COSDictionary field) {
        COSBase parent = field.getItem(COSName.PARENT);
        if (parent instanceof COSObject) {
            return (COSObject)parent;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompareFields
    implements Comparator<COSObject>,
    Serializable {
        private static final long serialVersionUID = -6081505461660440801L;

        CompareFields() {
        }

        @Override
        public int compare(COSObject o1, COSObject o2) {
            return (int)(o1.getObjectNumber() - o2.getObjectNumber());
        }
    }
}

