/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.fonts.cff.CFFDataReader;
import org.apache.fop.fonts.truetype.OTFSubSetWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OTFSubSetFile
extends OTFSubSetWriter {
    protected Map<Integer, Integer> gidToSID;
    protected List<byte[]> subsetLocalIndexSubr;
    protected List<Integer> localUniques;
    protected List<Integer> globalUniques;
    protected List<byte[]> subsetCharStringsIndex;
    protected String embeddedName;
    protected List<byte[]> stringIndexData = new ArrayList<byte[]>();
    protected CFFDataReader cffReader;
    public static final int NUM_STANDARD_STRINGS = 391;

    protected void writeTopDICT() throws IOException {
        LinkedHashMap topDICT = this.cffReader.getTopDictEntries();
        List<String> topDictStringEntries = Arrays.asList("version", "Notice", "Copyright", "FullName", "FamilyName", "Weight", "PostScript");
        for (Map.Entry dictEntry : topDICT.entrySet()) {
            String dictKey = (String)dictEntry.getKey();
            CFFDataReader.DICTEntry entry = (CFFDataReader.DICTEntry)dictEntry.getValue();
            if (dictKey.equals("ROS")) {
                this.writeROSEntry(entry);
                continue;
            }
            if (dictKey.equals("CIDCount")) {
                this.writeCIDCount(entry);
                continue;
            }
            if (topDictStringEntries.contains(dictKey)) {
                this.writeTopDictStringEntry(entry);
                continue;
            }
            this.writeBytes(entry.getByteData());
        }
    }

    private void writeROSEntry(CFFDataReader.DICTEntry dictEntry) throws IOException {
        int sidA = ((Number)dictEntry.getOperands().get(0)).intValue();
        if (sidA > 390) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(sidA - 391));
        }
        int sidAStringIndex = this.stringIndexData.size() + 390;
        int sidB = ((Number)dictEntry.getOperands().get(1)).intValue();
        if (sidB > 390) {
            this.stringIndexData.add("Identity".getBytes("UTF-8"));
        }
        int sidBStringIndex = this.stringIndexData.size() + 390;
        byte[] cidEntryByteData = dictEntry.getByteData();
        this.updateOffset(cidEntryByteData, 0, (Integer)dictEntry.getOperandLengths().get(0), sidAStringIndex);
        this.updateOffset(cidEntryByteData, (Integer)dictEntry.getOperandLengths().get(0), (Integer)dictEntry.getOperandLengths().get(1), sidBStringIndex);
        this.updateOffset(cidEntryByteData, (Integer)dictEntry.getOperandLengths().get(0) + (Integer)dictEntry.getOperandLengths().get(1), (Integer)dictEntry.getOperandLengths().get(2), 139);
        this.writeBytes(cidEntryByteData);
    }

    protected abstract void writeCIDCount(CFFDataReader.DICTEntry var1) throws IOException;

    private void writeTopDictStringEntry(CFFDataReader.DICTEntry dictEntry) throws IOException {
        int sid = ((Number)dictEntry.getOperands().get(0)).intValue();
        if (sid > 391) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(sid - 391));
        }
        byte[] newDictEntry = OTFSubSetFile.createNewRef(this.stringIndexData.size() + 390, dictEntry.getOperator(), dictEntry.getOperandLength());
        this.writeBytes(newDictEntry);
    }

    public static byte[] createNewRef(int newRef, int[] operatorCode, int forceLength) {
        ByteArrayOutputStream newRefBytes = new ByteArrayOutputStream();
        if (forceLength == -1 && newRef <= 107 || forceLength == 1) {
            newRefBytes.write(newRef + 139);
            for (int i : operatorCode) {
                newRefBytes.write(i);
            }
        } else if (forceLength == -1 && newRef <= 1131 || forceLength == 2) {
            if (newRef <= 363) {
                newRefBytes.write(247);
            } else if (newRef <= 619) {
                newRefBytes.write(248);
            } else if (newRef <= 875) {
                newRefBytes.write(249);
            } else {
                newRefBytes.write(250);
            }
            newRefBytes.write(newRef - 108);
            for (int i : operatorCode) {
                newRefBytes.write(i);
            }
        } else if (forceLength == -1 && newRef <= Short.MAX_VALUE || forceLength == 3) {
            newRefBytes.write(28);
            newRefBytes.write(newRef >> 8);
            newRefBytes.write(newRef);
            for (int i : operatorCode) {
                newRefBytes.write(i);
            }
        } else {
            newRefBytes.write(29);
            newRefBytes.write(newRef >> 24);
            newRefBytes.write(newRef >> 16);
            newRefBytes.write(newRef >> 8);
            newRefBytes.write(newRef);
            for (int i : operatorCode) {
                newRefBytes.write(i);
            }
        }
        return newRefBytes.toByteArray();
    }

    protected int writeIndex(List<byte[]> dataArray) {
        int hdrTotal = 3;
        this.writeCard16(dataArray.size());
        int totLength = 0;
        for (byte[] aDataArray1 : dataArray) {
            totLength += aDataArray1.length;
        }
        int offSize = 1;
        offSize = totLength <= 256 ? 1 : (totLength <= 65536 ? 2 : (totLength <= 0x1000000 ? 3 : 4));
        this.writeByte(offSize);
        hdrTotal += offSize;
        int total = 0;
        block7: for (int i = 0; i < dataArray.size(); ++i) {
            hdrTotal += offSize;
            int length = dataArray.get(i).length;
            switch (offSize) {
                case 1: {
                    if (i == 0) {
                        this.writeByte(1);
                    }
                    this.writeByte((total += length) + 1);
                    continue block7;
                }
                case 2: {
                    if (i == 0) {
                        this.writeCard16(1);
                    }
                    this.writeCard16((total += length) + 1);
                    continue block7;
                }
                case 3: {
                    if (i == 0) {
                        this.writeThreeByteNumber(1);
                    }
                    this.writeThreeByteNumber((total += length) + 1);
                    continue block7;
                }
                case 4: {
                    if (i == 0) {
                        this.writeULong(1);
                    }
                    this.writeULong((total += length) + 1);
                    continue block7;
                }
                default: {
                    throw new AssertionError((Object)"Offset Size was not an expected value.");
                }
            }
        }
        for (byte[] aDataArray : dataArray) {
            this.writeBytes(aDataArray);
        }
        return hdrTotal + total;
    }

    protected void writePrivateDict() throws IOException {
        LinkedHashMap topDICT = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            this.writeBytes(this.cffReader.getPrivateDictBytes(privateEntry));
        }
    }

    protected void updateOffsets(int topDictOffset, int charsetOffset, int charStringOffset, int privateDictOffset, int localIndexOffset, int encodingOffset) throws IOException {
        LinkedHashMap topDICT = this.cffReader.getTopDictEntries();
        Map privateDICT = null;
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            privateDICT = this.cffReader.getPrivateDict(privateEntry);
        }
        int dataPos = 3 + this.cffReader.getTopDictIndex().getOffSize() * this.cffReader.getTopDictIndex().getOffsets().length;
        int dataTopDictOffset = topDictOffset + dataPos;
        this.updateFixedOffsets(topDICT, dataTopDictOffset, charsetOffset, charStringOffset, encodingOffset);
        if (privateDICT != null) {
            int oldPrivateOffset = dataTopDictOffset + privateEntry.getOffset();
            this.updateOffset(this.output, oldPrivateOffset + (Integer)privateEntry.getOperandLengths().get(0), (Integer)privateEntry.getOperandLengths().get(1), privateDictOffset);
            CFFDataReader.DICTEntry subroutines = (CFFDataReader.DICTEntry)privateDICT.get("Subrs");
            if (subroutines != null) {
                int oldLocalSubrOffset = privateDictOffset + subroutines.getOffset();
                int encodeValue = 0;
                if (subroutines.getOperandLength() == 1) {
                    encodeValue = 139;
                }
                this.updateOffset(this.output, oldLocalSubrOffset, subroutines.getOperandLength(), localIndexOffset - privateDictOffset + encodeValue);
            }
        }
    }

    protected abstract void updateFixedOffsets(Map<String, CFFDataReader.DICTEntry> var1, int var2, int var3, int var4, int var5);

    protected void updateCIDOffsets(int topDictDataOffset, int fdArrayOffset, int fdSelectOffset, int charsetOffset, int charStringOffset, int encodingOffset) {
        CFFDataReader.DICTEntry fdSelect;
        LinkedHashMap topDict = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry fdArrayEntry = (CFFDataReader.DICTEntry)topDict.get("FDArray");
        if (fdArrayEntry != null) {
            this.updateOffset(this.output, topDictDataOffset + fdArrayEntry.getOffset() - 1, fdArrayEntry.getOperandLength(), fdArrayOffset);
        }
        if ((fdSelect = (CFFDataReader.DICTEntry)topDict.get("FDSelect")) != null) {
            this.updateOffset(this.output, topDictDataOffset + fdSelect.getOffset() - 1, fdSelect.getOperandLength(), fdSelectOffset);
        }
        this.updateFixedOffsets(topDict, topDictDataOffset, charsetOffset, charStringOffset, encodingOffset);
    }

    protected void updateOffset(byte[] out, int position, int length, int replacement) {
        switch (length) {
            case 1: {
                out[position] = (byte)(replacement & 0xFF);
                break;
            }
            case 2: {
                out[position] = replacement <= 363 ? -9 : (replacement <= 619 ? -8 : (replacement <= 875 ? -7 : -6));
                out[position + 1] = (byte)(replacement - 108);
                break;
            }
            case 3: {
                out[position] = 28;
                out[position + 1] = (byte)(replacement >> 8 & 0xFF);
                out[position + 2] = (byte)(replacement & 0xFF);
                break;
            }
            case 5: {
                out[position] = 29;
                out[position + 1] = (byte)(replacement >> 24 & 0xFF);
                out[position + 2] = (byte)(replacement >> 16 & 0xFF);
                out[position + 3] = (byte)(replacement >> 8 & 0xFF);
                out[position + 4] = (byte)(replacement & 0xFF);
                break;
            }
        }
    }
}

