/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Map;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.fop.render.pdf.pdfbox.PSPDFGraphics2D;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.java2d.GeneralGraphics2DImagePainter;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.apache.xmlgraphics.ps.PSGenerator;

public class ImageConverterPDF2G2D
extends AbstractImageConverter {
    public Image convert(Image src, Map hints) throws ImageException, IOException {
        this.checkSourceFlavor(src);
        assert (src instanceof ImagePDF);
        ImagePDF imgPDF = (ImagePDF)src;
        int selectedPage = ImageUtil.needPageIndexFromURI((String)src.getInfo().getOriginalURI());
        PDDocument pddoc = imgPDF.getPDDocument();
        Graphics2DImagePainterPDF painter = new Graphics2DImagePainterPDF(pddoc, selectedPage, imgPDF.getInfo().getOriginalURI());
        ImageGraphics2D g2dImage = new ImageGraphics2D(src.getInfo(), (Graphics2DImagePainter)painter);
        return g2dImage;
    }

    public ImageFlavor getSourceFlavor() {
        return ImagePDF.PDFBOX_IMAGE;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }

    public int getConversionPenalty() {
        return 1000;
    }

    private static class Graphics2DImagePainterPDF
    implements GeneralGraphics2DImagePainter {
        private final PDPage page;
        private final PDDocument pdDocument;
        private int selectedPage;
        private String uri;

        public Graphics2DImagePainterPDF(PDDocument pddoc, int selectedPage, String uri) {
            this.pdDocument = pddoc;
            this.selectedPage = selectedPage;
            this.page = this.pdDocument.getPage(selectedPage);
            this.uri = uri;
        }

        public Dimension getImageSize() {
            PDRectangle mediaBox = this.page.getMediaBox();
            int wmpt = (int)Math.ceil(mediaBox.getWidth() * 1000.0f);
            int hmpt = (int)Math.ceil(mediaBox.getHeight() * 1000.0f);
            return new Dimension(wmpt, hmpt);
        }

        public void paint(Graphics2D g2d, Rectangle2D area) {
            try {
                PDRectangle mediaBox = this.page.getCropBox();
                AffineTransform at = new AffineTransform();
                int rotation = this.page.getRotation();
                if (rotation == 90 || rotation == 270) {
                    at.scale(area.getWidth() / area.getHeight(), area.getHeight() / area.getWidth());
                }
                at.translate(area.getX(), area.getY());
                at.scale(area.getWidth() / (double)mediaBox.getWidth(), area.getHeight() / (double)mediaBox.getHeight());
                g2d.transform(at);
                new PDFRenderer(this.pdDocument).renderPageToGraphics(this.selectedPage, g2d);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while painting PDF page: " + this.uri + " " + t.getMessage(), t);
            }
        }

        public Graphics2D getGraphics(boolean textAsShapes, PSGenerator gen) {
            PSPDFGraphics2D graphics = new PSPDFGraphics2D(textAsShapes, gen);
            return graphics;
        }
    }
}

