/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.render.pdf.pdfbox.FOPPDFFont;
import org.apache.fop.render.pdf.pdfbox.FOPPDFMultiByteFont;
import org.apache.fop.render.pdf.pdfbox.FontContainer;
import org.apache.fop.render.pdf.pdfbox.MergeCFFFonts;
import org.apache.fop.render.pdf.pdfbox.MergeFonts;
import org.apache.fop.render.pdf.pdfbox.MergeFontsPDFWriter;
import org.apache.fop.render.pdf.pdfbox.MergeTTFonts;
import org.apache.fop.render.pdf.pdfbox.MergeType1Fonts;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.encoding.BuiltInEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOPPDFSingleByteFont
extends SingleByteFont
implements FOPPDFFont {
    private int fontCount;
    private FontContainer font;
    protected PDFDictionary ref;
    protected Map<String, Integer> charMapGlobal = new LinkedHashMap<String, Integer>();
    private Map<Integer, Integer> newWidth = new HashMap<Integer, Integer>();
    private Map<String, byte[]> charStringsDict;
    private List<MergeTTFonts.Cmap> newCmap = new ArrayList<MergeTTFonts.Cmap>();
    private Map<Integer, String> encodingMap = new TreeMap<Integer, String>();
    private int encodingSkip;
    private MergeFonts mergeFonts;
    private String shortFontName;
    private final Map<COSDictionary, FontContainer> fontMap = new HashMap<COSDictionary, FontContainer>();

    public FOPPDFSingleByteFont(COSDictionary fontData, String name) throws IOException {
        super(null, EmbeddingMode.FULL);
        if (fontData.getItem(COSName.SUBTYPE) == COSName.TRUE_TYPE) {
            this.setFontType(FontType.TRUETYPE);
        }
        this.width = new int[0];
        this.font = this.getFont(fontData);
        this.setFirstChar(this.font.getFirstChar());
        this.setLastChar(this.font.getLastChar());
        this.shortFontName = MergeFontsPDFWriter.getName(this.font.font.getName());
        this.loadFontFile(this.font);
        float[] bBoxF = this.font.getBoundingBox();
        int[] bBox = new int[bBoxF.length];
        for (int i = 0; i < bBox.length; ++i) {
            bBox[i] = (int)bBoxF[i];
        }
        this.setFontBBox(bBox);
        this.setFontName(name);
        Object cmap = this.getCmap(this.font);
        for (int i = this.font.getFirstChar(); i <= this.font.getLastChar(); ++i) {
            String mappedChar = this.getChar(cmap, i);
            if (mappedChar == null || this.charMapGlobal.containsKey(mappedChar)) continue;
            this.charMapGlobal.put(mappedChar, i);
        }
        this.notifyMapOperation();
        FOPPDFMultiByteFont.setProperties((CustomFont)this, this.font.font);
        if (this.font.getWidths() != null) {
            boolean usesZero = this.font.getWidths().contains(0);
            Set<Integer> codeToName = this.getCodeToName(this.font.getEncoding()).keySet();
            for (int i = this.getFirstChar(); i <= Math.min(this.getLastChar(), this.getFirstChar() + this.font.getWidths().size()); ++i) {
                if (usesZero || codeToName.contains(i)) {
                    int w = this.font.getWidths().get(i - this.getFirstChar());
                    this.newWidth.put(i, w);
                    continue;
                }
                this.newWidth.put(i, 0);
            }
        }
        this.mapping = new FOPPDFEncoding();
        this.encodingSkip = this.font.getLastChar() + 1;
        this.addEncoding(this.font);
    }

    private Map<Integer, String> getCodeToName(Encoding encoding) {
        HashMap<Integer, String> codeToName = new HashMap<Integer, String>();
        if (encoding != null) {
            COSBase cos = null;
            if (!(encoding instanceof BuiltInEncoding)) {
                cos = encoding.getCOSObject();
            }
            if (cos instanceof COSDictionary) {
                COSDictionary enc = (COSDictionary)cos;
                COSName baseEncodingName = (COSName)enc.getDictionaryObject(COSName.BASE_ENCODING);
                if (baseEncodingName != null) {
                    Encoding baseEncoding = Encoding.getInstance((COSName)baseEncodingName);
                    codeToName.putAll(baseEncoding.getCodeToNameMap());
                }
                COSArray differences = (COSArray)enc.getDictionaryObject(COSName.DIFFERENCES);
                int currentIndex = -1;
                for (int i = 0; differences != null && i < differences.size(); ++i) {
                    COSBase next = differences.getObject(i);
                    if (next instanceof COSNumber) {
                        currentIndex = ((COSNumber)next).intValue();
                        continue;
                    }
                    if (!(next instanceof COSName)) continue;
                    COSName name = (COSName)next;
                    codeToName.put(currentIndex++, name.getName());
                }
            } else {
                return encoding.getCodeToNameMap();
            }
        }
        return codeToName;
    }

    private Object getCmap(FontContainer font) throws IOException {
        if (font.getEncoding() != null) {
            return font.getEncoding();
        }
        if (font.getToUnicodeCMap() == null) {
            throw new IOException("No cmap found in " + font.font.getName());
        }
        return font.getToUnicodeCMap();
    }

    private PDStream readFontFile(PDFont font) throws IOException {
        PDFontDescriptor fd = font.getFontDescriptor();
        this.setFlags(fd.getFlags());
        PDStream ff = fd.getFontFile3();
        if (ff == null) {
            ff = fd.getFontFile2();
            if (ff == null) {
                ff = fd.getFontFile();
            }
        } else {
            this.setFontType(FontType.TYPE1C);
        }
        if (ff == null) {
            throw new IOException(font.getName() + " no font file");
        }
        return ff;
    }

    private void loadFontFile(FontContainer font) throws IOException {
        PDStream ff = this.readFontFile(font.font);
        this.mergeFontFile((InputStream)ff.createInputStream(), font);
        if (font.font instanceof PDTrueTypeFont) {
            CmapSubtable[] cmapList;
            TrueTypeFont ttfont = ((PDTrueTypeFont)font.font).getTrueTypeFont();
            for (CmapSubtable c : cmapList = ttfont.getCmap().getCmaps()) {
                MergeTTFonts.Cmap tempCmap = this.getNewCmap(c.getPlatformId(), c.getPlatformEncodingId());
                for (int i = 0; i < 65536; ++i) {
                    int gid = c.getGlyphId(i);
                    if (gid == 0) continue;
                    tempCmap.glyphIdToCharacterCode.put(i, gid);
                }
            }
            FOPPDFMultiByteFont.mergeMaxp(ttfont, ((MergeTTFonts)this.mergeFonts).maxp);
        }
    }

    private MergeTTFonts.Cmap getNewCmap(int platformID, int platformEncodingID) {
        for (MergeTTFonts.Cmap cmap : this.newCmap) {
            if (cmap.platformId != platformID || cmap.platformEncodingId != platformEncodingID) continue;
            return cmap;
        }
        MergeTTFonts.Cmap cmap = new MergeTTFonts.Cmap(platformID, platformEncodingID);
        this.newCmap.add(cmap);
        return cmap;
    }

    public boolean hasChar(char c) {
        return this.charMapGlobal.containsKey(String.valueOf(c));
    }

    public char mapChar(char c) {
        return this.mapping.mapChar(c);
    }

    public String getEmbedFontName() {
        return this.shortFontName;
    }

    public int[] getWidths() {
        this.width = new int[this.getLastChar() - this.getFirstChar() + 1];
        for (int i = this.getFirstChar(); i <= this.getLastChar(); ++i) {
            this.width[i - this.getFirstChar()] = this.newWidth.containsKey(i) ? this.newWidth.get(i) : 0;
        }
        return (int[])this.width.clone();
    }

    @Override
    public String addFont(COSDictionary fontData) throws IOException {
        FontContainer font = this.getFont(fontData);
        if ((font.font instanceof PDType1Font || font.font instanceof PDType1CFont) && this.differentGlyphData(font.font)) {
            return null;
        }
        this.mergeWidths(font);
        if (font.getFirstChar() < this.getFirstChar()) {
            this.setFirstChar(font.getFirstChar());
        }
        for (int w : this.newWidth.keySet()) {
            if (w <= this.getLastChar()) continue;
            this.setLastChar(w);
        }
        this.loadFontFile(font);
        this.addEncoding(font);
        return this.getFontName();
    }

    @Override
    public int size() {
        return this.fontCount;
    }

    private Map<String, byte[]> getCharStringsDict(PDFont font) throws IOException {
        if (font instanceof PDType1Font) {
            return ((PDType1Font)font).getType1Font().getCharStringsDict();
        }
        CFFType1Font cffFont = ((PDType1CFont)font).getCFFType1Font();
        List bytes = cffFont.getCharStringBytes();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (int i = 0; i < bytes.size(); ++i) {
            map.put(cffFont.getCharset().getNameForGID(i), (byte[])bytes.get(i));
        }
        return map;
    }

    private boolean differentGlyphData(PDFont otherFont) throws IOException {
        if (this.charStringsDict == null) {
            this.charStringsDict = this.getCharStringsDict(this.font.font);
        }
        Map<String, byte[]> otherFontMap = this.getCharStringsDict(otherFont);
        for (Map.Entry<String, byte[]> s : otherFontMap.entrySet()) {
            if (!this.charStringsDict.containsKey(s.getKey())) continue;
            int numberDiff = 0;
            byte[] b1 = this.charStringsDict.get(s.getKey());
            byte[] b2 = s.getValue();
            int b1Index = b1.length - 1;
            for (int b2Index = b2.length - 1; b1Index >= 0 && b2Index >= 0 && (b1[b1Index] == b2[b2Index] || ++numberDiff <= 2); --b1Index, --b2Index) {
            }
            if (numberDiff <= 2) continue;
            return true;
        }
        return false;
    }

    private void mergeWidths(FontContainer font) throws IOException {
        int w = 0;
        int skipGlyphIndex = this.getLastChar() + 1;
        Object cmap = this.getCmap(font);
        Set<Integer> codeToName = this.getCodeToName(font.getEncoding()).keySet();
        for (int i = font.getFirstChar(); i <= font.getLastChar(); ++i) {
            String mappedChar;
            boolean addedWidth = false;
            int glyphIndexPos = skipGlyphIndex;
            if (font.font instanceof PDTrueTypeFont) {
                glyphIndexPos = i;
            }
            int neww = 0;
            if (font.getWidths() != null) {
                neww = font.getWidths().get(i - font.getFirstChar());
                if (!this.newWidth.containsKey(i) || this.newWidth.get(i) == 0) {
                    if (this.getFontType() == FontType.TYPE1 || font.font instanceof PDTrueTypeFont || codeToName.contains(i)) {
                        this.newWidth.put(i, neww);
                        glyphIndexPos = i;
                    } else {
                        this.newWidth.put(i, 0);
                    }
                    addedWidth = true;
                }
            }
            if ((mappedChar = this.getChar(cmap, i)) != null && !this.charMapGlobal.containsKey(mappedChar)) {
                this.charMapGlobal.put(mappedChar, glyphIndexPos);
                if (!addedWidth && w < font.getWidths().size()) {
                    this.newWidth.put(this.newWidth.size() + this.getFirstChar(), neww);
                }
                ++skipGlyphIndex;
            }
            ++w;
        }
    }

    private String getChar(Object cmap, int i) throws IOException {
        if (cmap instanceof CMap) {
            CMap c = (CMap)cmap;
            return c.toUnicode(i);
        }
        Encoding enc = (Encoding)cmap;
        return enc.getName(i);
    }

    public String getEncodingName() {
        return this.font.getBaseEncodingName();
    }

    private void addEncoding(FontContainer fontForEnc) {
        ArrayList<String> added = new ArrayList<String>(this.encodingMap.values());
        Map<Integer, String> codeToName = this.getCodeToName(fontForEnc.getEncoding());
        for (int i = fontForEnc.getFirstChar(); i <= fontForEnc.getLastChar(); ++i) {
            String s;
            if (!codeToName.keySet().contains(i) || added.contains(s = codeToName.get(i)) && this.encodingMap.containsKey(i)) continue;
            if (!this.encodingMap.containsKey(i)) {
                this.encodingMap.put(i, s);
                continue;
            }
            this.encodingMap.put(this.encodingSkip, s);
            ++this.encodingSkip;
        }
    }

    public PDFDictionary getRef() {
        return this.ref;
    }

    @Override
    public void setRef(PDFDictionary d) {
        this.ref = d;
    }

    public boolean isEmbeddable() {
        return true;
    }

    public boolean isSymbolicFont() {
        return false;
    }

    private void mergeFontFile(InputStream ff, FontContainer pdFont) throws IOException {
        if (this.mergeFonts == null) {
            this.mergeFonts = this.getFontType() == FontType.TRUETYPE ? new MergeTTFonts(this.newCmap) : (this.getFontType() == FontType.TYPE1 ? new MergeType1Fonts() : new MergeCFFFonts());
        }
        HashMap<Integer, Integer> chars = new HashMap<Integer, Integer>();
        chars.put(0, 0);
        this.mergeFonts.readFont(ff, this.shortFontName, pdFont, chars, false);
        ++this.fontCount;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.mergeFonts.getMergedFontSubset());
    }

    protected FontContainer getFont(COSDictionary fontData) throws IOException {
        if (!this.fontMap.containsKey(fontData)) {
            if (this.fontMap.size() > 10) {
                this.fontMap.clear();
            }
            this.fontMap.put(fontData, new FontContainer(fontData));
        }
        return this.fontMap.get(fontData);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FOPPDFEncoding
    implements SingleByteEncoding {
        private boolean cmap;

        FOPPDFEncoding() {
        }

        public String getName() {
            return "FOPPDFEncoding";
        }

        public char mapChar(char c) {
            if (FOPPDFSingleByteFont.this.charMapGlobal.containsKey(String.valueOf(c))) {
                return (char)FOPPDFSingleByteFont.this.charMapGlobal.get(String.valueOf(c)).intValue();
            }
            return '\u0000';
        }

        public String[] getCharNameMap() {
            Collection v = FOPPDFSingleByteFont.this.encodingMap.values();
            return v.toArray(new String[v.size()]);
        }

        public char[] getUnicodeCharMap() {
            if (this.cmap) {
                if (FOPPDFSingleByteFont.this.font.getToUnicode() == null) {
                    return new char[0];
                }
                ArrayList<String> cmapStrings = new ArrayList<String>();
                HashMap<Integer, String> cm = new HashMap<Integer, String>();
                for (Map.Entry<String, Integer> o : FOPPDFSingleByteFont.this.charMapGlobal.entrySet()) {
                    cm.put(o.getValue(), o.getKey());
                }
                for (int i = 0; i < FOPPDFSingleByteFont.this.getLastChar() + 1; ++i) {
                    if (cm.containsKey(i)) {
                        cmapStrings.add((String)cm.get(i));
                        continue;
                    }
                    cmapStrings.add(" ");
                }
                return this.fromStringToCharArray(cmapStrings);
            }
            this.cmap = true;
            return this.toCharArray(FOPPDFSingleByteFont.this.encodingMap.keySet());
        }

        private char[] fromStringToCharArray(Collection<String> list) {
            char[] ret = new char[list.size()];
            int i = 0;
            for (String e : list) {
                if (e.length() <= 0) continue;
                ret[i++] = e.charAt(0);
            }
            return ret;
        }

        private char[] toCharArray(Collection<Integer> list) {
            char[] ret = new char[list.size()];
            int i = 0;
            for (int e : list) {
                ret[i++] = (char)e;
            }
            return ret;
        }
    }
}

