/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Cache<K, V> {
    Cache() {
    }

    public abstract V getValue(K var1, ValueMaker<V> var2) throws Exception;

    public static <K, V> Cache<K, V> createCache(Type cacheType) {
        switch (cacheType) {
            case WEAK: {
                return new WeakDocumentCache();
            }
            case SOFT: {
                return new SoftDocumentCache();
            }
            case STRONG: {
                return new StrongDocumentCache();
            }
        }
        return Cache.createDefaultCache();
    }

    private static <K, V> Cache<K, V> createDefaultCache() {
        return new WeakDocumentCache();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValueMaker<V> {
        public V make() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakDocumentCache<K, V>
    extends Cache<K, V> {
        private V currentValue;
        private K currentKey;

        private WeakDocumentCache() {
        }

        @Override
        public V getValue(K key, ValueMaker<V> valueMaker) throws Exception {
            if (!key.equals(this.currentKey)) {
                this.currentKey = key;
                this.currentValue = valueMaker.make();
            }
            return this.currentValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftDocumentCache<K, V>
    extends Cache<K, V> {
        private final Map<K, SoftReference<Object>> softKeys = new HashMap<K, SoftReference<Object>>();
        private final Map<Object, V> cache = new WeakHashMap<Object, V>();

        private SoftDocumentCache() {
        }

        @Override
        public V getValue(K key, ValueMaker<V> valueMaker) throws Exception {
            Object softKey;
            SoftReference<Object> reference = this.softKeys.get(key);
            if (reference == null || reference.get() == null) {
                softKey = new Object();
                reference = new SoftReference<Object>(softKey);
                this.softKeys.put(key, reference);
            } else {
                softKey = reference.get();
            }
            V value = this.cache.get(softKey);
            if (value == null) {
                value = valueMaker.make();
                this.cache.put(softKey, value);
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongDocumentCache<K, V>
    extends Cache<K, V> {
        private final Map<K, V> cache = new HashMap();

        private StrongDocumentCache() {
        }

        @Override
        public V getValue(K key, ValueMaker<V> valueMaker) throws Exception {
            V value = this.cache.get(key);
            if (value == null) {
                value = valueMaker.make();
                this.cache.put(key, value);
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        WEAK,
        SOFT,
        STRONG;

    }
}

