/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.xquery.saxon;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.XmlTokenSource;
import org.apache.xmlbeans.impl.store.SaxonXBeansDelegate;
import org.w3c.dom.Node;

public class XBeansXQuery
implements SaxonXBeansDelegate.QueryInterface {
    private XQueryExpression _xquery;
    private String _query;
    private String _contextVar;
    private StaticQueryContext _stcContext;
    private Configuration config;
    private int boundary;
    private boolean needsDomSourceWrapping = XBeansXQuery.needsDOMSourceWrapping();

    public XBeansXQuery(String queryExpr, String contextVar, Integer boundary) {
        this.config = new Configuration();
        this.config.setTreeModel(0);
        this._stcContext = new StaticQueryContext(this.config);
        this._query = queryExpr;
        this._contextVar = contextVar;
        this.boundary = boundary;
        String queryExp = this.boundary == 0 ? "declare variable $" + this._contextVar + " external;" + this._query : this._query.substring(0, this.boundary) + "declare variable $" + this._contextVar + " external;" + this._query.substring(this.boundary);
        try {
            this._xquery = this._stcContext.compileQuery(queryExp);
        }
        catch (TransformerException e) {
            throw new XmlRuntimeException((Throwable)e);
        }
    }

    public List execQuery(Object node, Map variableBindings) {
        try {
            Node context_node = (Node)node;
            DynamicQueryContext dynamicContext = new DynamicQueryContext(this.config);
            dynamicContext.setContextNode((NodeInfo)this._stcContext.buildDocument((Source)new DOMSource(context_node)));
            dynamicContext.setParameter(this._contextVar, (Object)dynamicContext.getContextItem());
            if (variableBindings != null) {
                Iterator it = variableBindings.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (entry.getValue() instanceof XmlTokenSource) {
                        Object paramObject = this.needsDomSourceWrapping ? new DOMSource(((XmlTokenSource)entry.getValue()).getDomNode()) : ((XmlTokenSource)entry.getValue()).getDomNode();
                        dynamicContext.setParameter((String)entry.getKey(), paramObject);
                        continue;
                    }
                    if (!(entry.getValue() instanceof String)) continue;
                    dynamicContext.setParameter((String)entry.getKey(), entry.getValue());
                }
            }
            List saxonNodes = this._xquery.evaluate(dynamicContext);
            ListIterator<NodeOverNodeInfo> it = saxonNodes.listIterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof NodeInfo)) continue;
                NodeOverNodeInfo n = NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)o));
                it.set(n);
            }
            return saxonNodes;
        }
        catch (TransformerException e) {
            throw new RuntimeException(" Error binding " + this._contextVar, e);
        }
    }

    private static boolean needsDOMSourceWrapping() {
        String versionString = Version.getProductVersion();
        int dot1 = versionString.indexOf(46);
        if (dot1 < 0) {
            return false;
        }
        int dot2 = versionString.indexOf(46, dot1 + 1);
        if (dot2 < 0) {
            return false;
        }
        try {
            int saxonMajorVersion = Integer.parseInt(versionString.substring(0, dot1));
            int saxonMinorVersion = Integer.parseInt(versionString.substring(dot1 + 1, dot2));
            return saxonMajorVersion == 8 && saxonMinorVersion <= 6;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

