/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractSymmetricAsymmetricBinding;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.EncryptedElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class SignatureProtectionAssertionState
extends AssertionState
implements Assertable {
    private final List<List<QName>> elementPaths = new ArrayList<List<QName>>();

    public SignatureProtectionAssertionState(AbstractSecurityAssertion assertion, boolean asserted) {
        super((Assertion)assertion, asserted);
        LinkedList<QName> signature11Path = new LinkedList<QName>();
        signature11Path.addAll(WSSConstants.SOAP_11_HEADER_PATH);
        signature11Path.add(WSSConstants.TAG_wsse_Security);
        signature11Path.add(WSSConstants.TAG_dsig_Signature);
        this.elementPaths.add(signature11Path);
        LinkedList<QName> signatureConfirmation11Path = new LinkedList<QName>();
        signatureConfirmation11Path.addAll(WSSConstants.SOAP_11_HEADER_PATH);
        signatureConfirmation11Path.add(WSSConstants.TAG_wsse_Security);
        signatureConfirmation11Path.add(WSSConstants.TAG_wsse11_SignatureConfirmation);
        this.elementPaths.add(signatureConfirmation11Path);
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.EncryptedElement};
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        EncryptedElementSecurityEvent encryptedElementSecurityEvent = (EncryptedElementSecurityEvent)securityEvent;
        AbstractSymmetricAsymmetricBinding abstractSymmetricAsymmetricBinding = (AbstractSymmetricAsymmetricBinding)this.getAssertion();
        for (List<QName> qNameList : this.elementPaths) {
            if (!WSSUtils.pathMatches(qNameList, (List)encryptedElementSecurityEvent.getElementPath(), (boolean)true, (boolean)false)) continue;
            if (encryptedElementSecurityEvent.isEncrypted()) {
                if (abstractSymmetricAsymmetricBinding.isEncryptSignature()) {
                    this.setAsserted(true);
                    return true;
                }
                this.setAsserted(false);
                this.setErrorMessage("Element " + WSSUtils.pathAsString((List)encryptedElementSecurityEvent.getElementPath()) + " must not be encrypted");
                return false;
            }
            if (abstractSymmetricAsymmetricBinding.isEncryptSignature()) {
                this.setAsserted(false);
                this.setErrorMessage("Element " + WSSUtils.pathAsString((List)encryptedElementSecurityEvent.getElementPath()) + " must be encrypted");
                return false;
            }
            this.setAsserted(true);
            return true;
        }
        return true;
    }
}

