/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.KerberosToken;
import org.apache.wss4j.policy.stax.assertionStates.TokenAssertionState;
import org.apache.wss4j.stax.securityEvent.KerberosTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.securityToken.KerberosServiceSecurityToken;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;

public class KerberosTokenAssertionState
extends TokenAssertionState {
    public KerberosTokenAssertionState(AbstractSecurityAssertion assertion, boolean asserted, boolean initiator) {
        super(assertion, asserted, initiator);
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.KerberosToken};
    }

    @Override
    public boolean assertToken(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, AbstractToken abstractToken) throws WSSPolicyException {
        if (!(tokenSecurityEvent instanceof KerberosTokenSecurityEvent)) {
            throw new WSSPolicyException("Expected a KerberosTokenSecurityEvent but got " + tokenSecurityEvent.getClass().getName());
        }
        KerberosToken kerberosToken = (KerberosToken)abstractToken;
        KerberosTokenSecurityEvent kerberosTokenSecurityEvent = (KerberosTokenSecurityEvent)tokenSecurityEvent;
        KerberosServiceSecurityToken kerberosServiceSecurityToken = (KerberosServiceSecurityToken)kerberosTokenSecurityEvent.getSecurityToken();
        if (kerberosToken.getIssuerName() != null && !kerberosToken.getIssuerName().equals(kerberosTokenSecurityEvent.getIssuerName())) {
            this.setErrorMessage("IssuerName in Policy (" + kerberosToken.getIssuerName() + ") didn't match with the one in the IssuedToken (" + kerberosTokenSecurityEvent.getIssuerName() + ")");
            return false;
        }
        if (kerberosToken.isRequireKeyIdentifierReference() && !WSSecurityTokenConstants.KeyIdentifier_EmbeddedKeyIdentifierRef.equals((Object)kerberosServiceSecurityToken.getKeyIdentifier())) {
            this.setErrorMessage("Policy enforces KeyIdentifierReference but we got " + kerberosServiceSecurityToken.getKeyIdentifier());
            return false;
        }
        if (kerberosToken.getApReqTokenType() != null) {
            switch (kerberosToken.getApReqTokenType()) {
                case WssKerberosV5ApReqToken11: {
                    if (kerberosTokenSecurityEvent.isKerberosV5ApReqToken11()) break;
                    this.setErrorMessage("Policy enforces " + kerberosToken.getApReqTokenType());
                    return false;
                }
                case WssGssKerberosV5ApReqToken11: {
                    if (kerberosTokenSecurityEvent.isGssKerberosV5ApReqToken11()) break;
                    this.setErrorMessage("Policy enforces " + kerberosToken.getApReqTokenType());
                    return false;
                }
            }
        }
        return true;
    }
}

