/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.HttpsToken;
import org.apache.wss4j.policy.stax.assertionStates.TokenAssertionState;
import org.apache.wss4j.stax.securityEvent.HttpsTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;

public class HttpsTokenAssertionState
extends TokenAssertionState {
    public HttpsTokenAssertionState(AbstractSecurityAssertion assertion, boolean asserted, boolean initiator) {
        super(assertion, asserted, initiator);
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.HttpsToken};
    }

    @Override
    public boolean assertToken(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, AbstractToken abstractToken) throws WSSPolicyException {
        if (!(tokenSecurityEvent instanceof HttpsTokenSecurityEvent)) {
            throw new WSSPolicyException("Expected a HttpsTokenSecurityEvent but got " + tokenSecurityEvent.getClass().getName());
        }
        HttpsTokenSecurityEvent httpsTokenSecurityEvent = (HttpsTokenSecurityEvent)tokenSecurityEvent;
        HttpsToken httpsToken = (HttpsToken)abstractToken;
        if (httpsToken.getIssuerName() != null && !httpsToken.getIssuerName().equals(httpsTokenSecurityEvent.getIssuerName())) {
            this.setErrorMessage("IssuerName in Policy (" + httpsToken.getIssuerName() + ") didn't match with the one in the HttpsToken (" + httpsTokenSecurityEvent.getIssuerName() + ")");
            return false;
        }
        if (httpsToken.getAuthenticationType() != null) {
            switch (httpsToken.getAuthenticationType()) {
                case HttpBasicAuthentication: {
                    if (httpsTokenSecurityEvent.getAuthenticationType() == HttpsTokenSecurityEvent.AuthenticationType.HttpBasicAuthentication) break;
                    this.setErrorMessage("Policy enforces HttpBasicAuthentication but we got " + httpsTokenSecurityEvent.getAuthenticationType());
                    return false;
                }
                case HttpDigestAuthentication: {
                    if (httpsTokenSecurityEvent.getAuthenticationType() == HttpsTokenSecurityEvent.AuthenticationType.HttpDigestAuthentication) break;
                    this.setErrorMessage("Policy enforces HttpDigestAuthentication but we got " + httpsTokenSecurityEvent.getAuthenticationType());
                    return false;
                }
                case RequireClientCertificate: {
                    if (httpsTokenSecurityEvent.getAuthenticationType() == HttpsTokenSecurityEvent.AuthenticationType.HttpsClientCertificateAuthentication) break;
                    this.setErrorMessage("Policy enforces HttpClientCertificateAuthentication but we got " + httpsTokenSecurityEvent.getAuthenticationType());
                    return false;
                }
            }
        }
        return true;
    }
}

