/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.EncryptedElements;
import org.apache.wss4j.policy.model.XPath;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.policy.stax.PolicyUtils;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.EncryptedElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class EncryptedElementsAssertionState
extends AssertionState
implements Assertable {
    private final List<List<QName>> pathElements = new ArrayList<List<QName>>();

    public EncryptedElementsAssertionState(AbstractSecurityAssertion assertion, boolean asserted) {
        super((Assertion)assertion, asserted);
        EncryptedElements encryptedElements = (EncryptedElements)assertion;
        for (int i = 0; i < encryptedElements.getXPaths().size(); ++i) {
            XPath xPath = (XPath)encryptedElements.getXPaths().get(i);
            List<QName> elements = PolicyUtils.getElementPath(xPath);
            this.pathElements.add(elements);
        }
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.EncryptedElement};
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        EncryptedElementSecurityEvent encryptedElementSecurityEvent = (EncryptedElementSecurityEvent)securityEvent;
        for (List<QName> pathElements : this.pathElements) {
            if (!WSSUtils.pathMatches(pathElements, (List)encryptedElementSecurityEvent.getElementPath(), (boolean)true, (boolean)false)) continue;
            if (encryptedElementSecurityEvent.isEncrypted()) {
                this.setAsserted(true);
                return true;
            }
            this.setAsserted(false);
            this.setErrorMessage("Element " + WSSUtils.pathAsString((List)encryptedElementSecurityEvent.getElementPath()) + " must be encrypted");
            return false;
        }
        return true;
    }
}

