/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import org.apache.neethi.Assertion;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.securityEvent.AlgorithmSuiteSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class AlgorithmSuiteAssertionState
extends AssertionState
implements Assertable {
    public AlgorithmSuiteAssertionState(AbstractSecurityAssertion assertion, boolean asserted) {
        super((Assertion)assertion, asserted);
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{SecurityEventConstants.AlgorithmSuite};
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        AlgorithmSuiteSecurityEvent algorithmSuiteSecurityEvent = (AlgorithmSuiteSecurityEvent)securityEvent;
        AlgorithmSuite algorithmSuite = (AlgorithmSuite)this.getAssertion();
        XMLSecurityConstants.AlgorithmUsage keyUsage = algorithmSuiteSecurityEvent.getAlgorithmUsage();
        if (WSSConstants.Sym_Sig.equals((Object)keyUsage)) {
            if (algorithmSuite.getSymmetricSignature() != null && !algorithmSuite.getSymmetricSignature().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Symmetric signature algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null) {
                if (!(algorithmSuiteSecurityEvent.isDerivedKey() || algorithmSuite.getAlgorithmSuiteType().getMinimumSymmetricKeyLength() <= algorithmSuiteSecurityEvent.getKeyLength() && algorithmSuite.getAlgorithmSuiteType().getMaximumSymmetricKeyLength() >= algorithmSuiteSecurityEvent.getKeyLength())) {
                    this.setAsserted(false);
                    this.setErrorMessage("Symmetric signature algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                } else if (algorithmSuiteSecurityEvent.isDerivedKey() && algorithmSuite.getAlgorithmSuiteType().getSignatureDerivedKeyLength() != algorithmSuiteSecurityEvent.getKeyLength()) {
                    this.setAsserted(false);
                    this.setErrorMessage("Symmetric signature algorithm derived key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                }
            }
        } else if (WSSConstants.Asym_Sig.equals((Object)keyUsage)) {
            if (algorithmSuite.getAsymmetricSignature() != null && !algorithmSuite.getAsymmetricSignature().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Asymmetric algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null && (algorithmSuite.getAlgorithmSuiteType().getMinimumAsymmetricKeyLength() > algorithmSuiteSecurityEvent.getKeyLength() || algorithmSuite.getAlgorithmSuiteType().getMaximumAsymmetricKeyLength() < algorithmSuiteSecurityEvent.getKeyLength())) {
                this.setAsserted(false);
                this.setErrorMessage("Asymmetric signature algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
            }
        } else if (WSSConstants.Dig.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getDigest().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Digest algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
        } else if (WSSConstants.Enc.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getEncryption().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Encryption algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null) {
                if (!(algorithmSuiteSecurityEvent.isDerivedKey() || algorithmSuite.getAlgorithmSuiteType().getMinimumSymmetricKeyLength() <= algorithmSuiteSecurityEvent.getKeyLength() && algorithmSuite.getAlgorithmSuiteType().getMaximumSymmetricKeyLength() >= algorithmSuiteSecurityEvent.getKeyLength())) {
                    this.setAsserted(false);
                    this.setErrorMessage("Symmetric encryption algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                } else if (algorithmSuiteSecurityEvent.isDerivedKey() && algorithmSuite.getAlgorithmSuiteType().getEncryptionDerivedKeyLength() != algorithmSuiteSecurityEvent.getKeyLength()) {
                    this.setAsserted(false);
                    this.setErrorMessage("Symmetric encryption algorithm derived key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                }
            }
        } else if (WSSConstants.Sym_Key_Wrap.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getSymmetricKeyWrap().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Symmetric key wrap algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null && (algorithmSuite.getAlgorithmSuiteType().getMinimumSymmetricKeyLength() > algorithmSuiteSecurityEvent.getKeyLength() || algorithmSuite.getAlgorithmSuiteType().getMaximumSymmetricKeyLength() < algorithmSuiteSecurityEvent.getKeyLength())) {
                this.setAsserted(false);
                this.setErrorMessage("Symmetric key wrap algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
            }
        } else if (WSSConstants.Asym_Key_Wrap.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getAsymmetricKeyWrap().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Asymmetric key wrap algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null && (algorithmSuite.getAlgorithmSuiteType().getMinimumAsymmetricKeyLength() > algorithmSuiteSecurityEvent.getKeyLength() || algorithmSuite.getAlgorithmSuiteType().getMaximumAsymmetricKeyLength() < algorithmSuiteSecurityEvent.getKeyLength())) {
                this.setAsserted(false);
                this.setErrorMessage("Asymmetric key wrap algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
            }
        } else if (WSSConstants.Comp_Key.equals((Object)keyUsage)) {
            if (algorithmSuite.getComputedKey() != null && !algorithmSuite.getComputedKey().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Computed key algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
        } else if (WSSConstants.Enc_KD.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getEncryptionKeyDerivation().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Encryption key derivation algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
        } else if (WSSConstants.Sig_KD.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getSignatureKeyDerivation().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Signature key derivation algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
        } else if (WSSConstants.C14n.equals((Object)keyUsage)) {
            if (algorithmSuite.getC14n() != null && !algorithmSuite.getC14n().getValue().equals(algorithmSuiteSecurityEvent.getAlgorithmURI()) && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("C14N algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
        } else if (WSSConstants.Soap_Norm.equals((Object)keyUsage)) {
            if (algorithmSuite.getSoapNormType() != null && !algorithmSuite.getSoapNormType().getValue().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Soap normalization algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
        } else if (WSSConstants.STR_Trans.equals((Object)keyUsage)) {
            if (algorithmSuite.getStrType() != null && !algorithmSuite.getStrType().getValue().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("STR transformation algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            }
        } else if (WSSConstants.XPath.equals((Object)keyUsage) && algorithmSuite.getXPathType() != null && !algorithmSuite.getXPathType().getValue().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
            this.setAsserted(false);
            this.setErrorMessage("XPath algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
        }
        return this.isAsserted();
    }
}

