/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import org.apache.wss4j.common.crypto.CryptoBase;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merlin
extends CryptoBase {
    public static final String ENCRYPTED_PASSWORD_PREFIX = "ENC(";
    public static final String ENCRYPTED_PASSWORD_SUFFIX = ")";
    public static final String PREFIX = "org.apache.wss4j.crypto.merlin.";
    public static final String OLD_PREFIX = "org.apache.ws.security.crypto.merlin.";
    public static final String OLD_KEYSTORE_FILE = "file";
    public static final String CRYPTO_KEYSTORE_PROVIDER = "keystore.provider";
    public static final String CRYPTO_CERT_PROVIDER = "cert.provider";
    public static final String KEYSTORE_FILE = "keystore.file";
    public static final String KEYSTORE_PASSWORD = "keystore.password";
    public static final String KEYSTORE_TYPE = "keystore.type";
    public static final String KEYSTORE_ALIAS = "keystore.alias";
    public static final String KEYSTORE_PRIVATE_PASSWORD = "keystore.private.password";
    public static final String LOAD_CA_CERTS = "load.cacerts";
    public static final String TRUSTSTORE_FILE = "truststore.file";
    public static final String TRUSTSTORE_PASSWORD = "truststore.password";
    public static final String TRUSTSTORE_TYPE = "truststore.type";
    public static final String X509_CRL_FILE = "x509crl.file";
    private static final Logger LOG = LoggerFactory.getLogger(Merlin.class);
    private static final boolean DO_DEBUG = LOG.isDebugEnabled();
    protected Properties properties;
    protected KeyStore keystore;
    protected KeyStore truststore;
    protected CertStore crlCertStore;
    protected boolean loadCACerts;
    protected boolean privatePasswordSet;
    protected PasswordEncryptor passwordEncryptor;

    public Merlin() {
    }

    public Merlin(boolean loadCACerts, String cacertsPasswd) {
        if (this.truststore == null && loadCACerts) {
            String cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
            try (FileInputStream cacertsIs = new FileInputStream(cacertsPath);){
                this.truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                this.truststore.load(cacertsIs, cacertsPasswd.toCharArray());
                loadCACerts = true;
            }
            catch (Exception e) {
                LOG.warn("CA certs could not be loaded: " + e.getMessage());
            }
        }
    }

    public Merlin(Properties properties, ClassLoader loader, PasswordEncryptor passwordEncryptor) throws WSSecurityException, IOException {
        this.loadProperties(properties, loader, passwordEncryptor);
    }

    /*
     * Unable to fully structure code
     */
    public void loadProperties(Properties properties, ClassLoader loader, PasswordEncryptor passwordEncryptor) throws WSSecurityException, IOException {
        if (properties == null) {
            return;
        }
        this.properties = properties;
        this.passwordEncryptor = passwordEncryptor;
        prefix = "org.apache.wss4j.crypto.merlin.";
        for (Object key : properties.keySet()) {
            if (!(key instanceof String)) continue;
            propKey = (String)key;
            if (propKey.startsWith("org.apache.wss4j.crypto.merlin.")) break;
            if (!propKey.startsWith("org.apache.ws.security.crypto.merlin.")) continue;
            prefix = "org.apache.ws.security.crypto.merlin.";
            break;
        }
        if ((provider = properties.getProperty(prefix + "keystore.provider")) != null) {
            provider = provider.trim();
        }
        if ((certProvider = properties.getProperty(prefix + "cert.provider")) != null) {
            this.setCryptoProvider(certProvider);
        }
        if ((alias = properties.getProperty(prefix + "keystore.alias")) != null) {
            alias = alias.trim();
            this.setDefaultX509Identifier(alias);
        }
        if ((keyStoreLocation = properties.getProperty(prefix + "keystore.file")) == null) {
            keyStoreLocation = properties.getProperty(prefix + "file");
        }
        if (keyStoreLocation != null) {
            keyStoreLocation = keyStoreLocation.trim();
            is = Merlin.loadInputStream(loader, keyStoreLocation);
            var10_10 = null;
            try {
                passwd = properties.getProperty(prefix + "keystore.password", "security");
                if (passwd != null) {
                    passwd = passwd.trim();
                    passwd = this.decryptPassword(passwd, passwordEncryptor);
                }
                if ((type = properties.getProperty(prefix + "keystore.type", KeyStore.getDefaultType())) != null) {
                    type = type.trim();
                }
                this.keystore = this.load(is, passwd, provider, type);
                if (Merlin.DO_DEBUG) {
                    Merlin.LOG.debug("The KeyStore " + keyStoreLocation + " of type " + type + " has been loaded");
                }
                if ((privatePasswd = properties.getProperty(prefix + "keystore.private.password")) == null) ** GOTO lbl55
                this.privatePasswordSet = true;
            }
            catch (Throwable x2) {
                var10_10 = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (var10_10 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            var10_10.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        } else if (Merlin.DO_DEBUG) {
            Merlin.LOG.debug("The KeyStore is not loaded as KEYSTORE_FILE is null");
        }
lbl55:
        // 5 sources

        if ((trustStoreLocation = properties.getProperty(prefix + "truststore.file")) != null) {
            trustStoreLocation = trustStoreLocation.trim();
            is = Merlin.loadInputStream(loader, trustStoreLocation);
            x2 = null;
            try {
                passwd = properties.getProperty(prefix + "truststore.password", "changeit");
                if (passwd != null) {
                    passwd = passwd.trim();
                    passwd = this.decryptPassword(passwd, passwordEncryptor);
                }
                if ((type = properties.getProperty(prefix + "truststore.type", KeyStore.getDefaultType())) != null) {
                    type = type.trim();
                }
                this.truststore = this.load(is, passwd, provider, (String)type);
                if (Merlin.DO_DEBUG) {
                    Merlin.LOG.debug("The TrustStore " + trustStoreLocation + " of type " + (String)type + " has been loaded");
                }
                this.loadCACerts = false;
            }
            catch (Throwable x2) {
                x2 = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (x2 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            x2.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        loadCacerts = properties.getProperty(prefix + "load.cacerts", "false");
        if (loadCacerts != null) {
            loadCacerts = loadCacerts.trim();
        }
        if (Boolean.valueOf(loadCacerts).booleanValue()) {
            cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
            if (cacertsPath != null) {
                cacertsPath = cacertsPath.trim();
            }
            is = new FileInputStream(cacertsPath);
            type = null;
            try {
                cacertsPasswd = properties.getProperty(prefix + "truststore.password", "changeit");
                if (cacertsPasswd != null) {
                    cacertsPasswd = cacertsPasswd.trim();
                    cacertsPasswd = this.decryptPassword(cacertsPasswd, passwordEncryptor);
                }
                this.truststore = this.load(is, cacertsPasswd, null, KeyStore.getDefaultType());
                if (Merlin.DO_DEBUG) {
                    Merlin.LOG.debug("CA certs have been loaded");
                }
                this.loadCACerts = true;
            }
            catch (Throwable x2) {
                type = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (type != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            type.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        if ((crlLocation = properties.getProperty(prefix + "x509crl.file")) != null) {
            crlLocation = crlLocation.trim();
            try {
                is = Merlin.loadInputStream(loader, crlLocation);
                var12_15 = null;
                try {
                    cf = this.getCertificateFactory();
                    crl = (X509CRL)cf.generateCRL(is);
                    this.crlCertStore = provider == null || provider.length() == 0 ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singletonList(crl))) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Collections.singletonList(crl)), provider);
                    if (Merlin.DO_DEBUG) {
                        Merlin.LOG.debug("The CRL " + crlLocation + " has been loaded");
                    }
                }
                catch (Throwable var13_20) {
                    var12_15 = var13_20;
                    throw var13_20;
                }
                finally {
                    if (is != null) {
                        if (var12_15 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                var12_15.addSuppressed(x2);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                if (Merlin.DO_DEBUG) {
                    Merlin.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "failedCredentialLoad");
            }
        }
    }

    public static InputStream loadInputStream(ClassLoader loader, String location) throws WSSecurityException, IOException {
        InputStream is = null;
        if (location != null) {
            URL url = Loader.getResource(loader, location);
            if (url != null) {
                is = url.openStream();
            }
            if (is == null) {
                try {
                    is = new FileInputStream(location);
                }
                catch (Exception e) {
                    if (DO_DEBUG) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "proxyNotFound", new Object[]{location});
                }
            }
        }
        return is;
    }

    protected KeyStore load(InputStream input, String storepass, String provider, String type) throws WSSecurityException {
        KeyStore ks = null;
        try {
            ks = provider == null || provider.length() == 0 ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            ks.load(input, storepass == null || storepass.length() == 0 ? new char[]{} : storepass.toCharArray());
        }
        catch (IOException | GeneralSecurityException e) {
            if (DO_DEBUG) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "failedCredentialLoad");
        }
        return ks;
    }

    public KeyStore getKeyStore() {
        return this.keystore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keystore = keyStore;
    }

    public KeyStore getTrustStore() {
        return this.truststore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.truststore = trustStore;
    }

    public void setCRLCertStore(CertStore crlCertStore) {
        this.crlCertStore = crlCertStore;
    }

    public CertStore getCRLCertStore() {
        return this.crlCertStore;
    }

    @Override
    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        block10: {
            if (this.certificateFactory != null) {
                return this.certificateFactory;
            }
            String provider = this.getCryptoProvider();
            String keyStoreProvider = null;
            if (this.keystore != null) {
                keyStoreProvider = this.keystore.getProvider().getName();
            }
            try {
                if (provider == null || provider.length() == 0) {
                    if (keyStoreProvider != null && keyStoreProvider.length() != 0) {
                        try {
                            this.certificateFactory = CertificateFactory.getInstance("X.509", this.mapKeystoreProviderToCertProvider(keyStoreProvider));
                        }
                        catch (Exception ex) {
                            LOG.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    if (this.certificateFactory == null) {
                        this.certificateFactory = CertificateFactory.getInstance("X.509");
                    }
                    break block10;
                }
                this.certificateFactory = CertificateFactory.getInstance("X.509", provider);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, e, "unsupportedCertType");
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, e, "noSecProvider");
            }
        }
        return this.certificateFactory;
    }

    private String mapKeystoreProviderToCertProvider(String s) {
        if ("SunJSSE".equals(s)) {
            return "SUN";
        }
        return s;
    }

    @Override
    public String getDefaultX509Identifier() throws WSSecurityException {
        if (super.getDefaultX509Identifier() != null) {
            return super.getDefaultX509Identifier();
        }
        if (this.keystore != null) {
            try {
                Enumeration<String> as = this.keystore.aliases();
                if (as.hasMoreElements()) {
                    String alias = as.nextElement();
                    if (!as.hasMoreElements()) {
                        this.setDefaultX509Identifier(alias);
                        return alias;
                    }
                }
            }
            catch (KeyStoreException ex) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex, "keystore");
            }
        }
        return null;
    }

    @Override
    public X509Certificate[] getX509Certificates(CryptoType cryptoType) throws WSSecurityException {
        if (cryptoType == null) {
            return null;
        }
        CryptoType.TYPE type = cryptoType.getType();
        X509Certificate[] certs = null;
        switch (type) {
            case ISSUER_SERIAL: {
                certs = this.getX509Certificates(cryptoType.getIssuer(), cryptoType.getSerial());
                break;
            }
            case THUMBPRINT_SHA1: {
                certs = this.getX509Certificates(cryptoType.getBytes());
                break;
            }
            case SKI_BYTES: {
                certs = this.getX509CertificatesSKI(cryptoType.getBytes());
                break;
            }
            case SUBJECT_DN: {
                certs = this.getX509CertificatesSubjectDN(cryptoType.getSubjectDN());
                break;
            }
            case ALIAS: {
                certs = this.getX509Certificates(cryptoType.getAlias());
                break;
            }
        }
        return certs;
    }

    @Override
    public String getX509Identifier(X509Certificate cert) throws WSSecurityException {
        String identifier = null;
        if (this.keystore != null) {
            identifier = this.getIdentifier(cert, this.keystore);
        }
        if (identifier == null && this.truststore != null) {
            identifier = this.getIdentifier(cert, this.truststore);
        }
        return identifier;
    }

    @Override
    public PrivateKey getPrivateKey(X509Certificate certificate, CallbackHandler callbackHandler) throws WSSecurityException {
        if (this.keystore == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"The keystore is null"});
        }
        if (callbackHandler == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"The CallbackHandler is null"});
        }
        String identifier = this.getIdentifier(certificate, this.keystore);
        try {
            Key keyTmp;
            if (identifier == null || !this.keystore.isKeyEntry(identifier)) {
                String msg = "Cannot find key for alias: [" + identifier + "]";
                String logMsg = Merlin.createKeyStoreErrorMessage(this.keystore);
                LOG.error(msg + logMsg);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{msg});
            }
            String password = this.getPassword(identifier, callbackHandler);
            if (password == null && this.privatePasswordSet) {
                password = this.properties.getProperty("org.apache.wss4j.crypto.merlin.keystore.private.password");
                if (password == null) {
                    password = this.properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.private.password");
                }
                if (password != null) {
                    password = password.trim();
                    password = this.decryptPassword(password, this.passwordEncryptor);
                }
            }
            if (!((keyTmp = this.keystore.getKey(identifier, password == null ? new char[]{} : password.toCharArray())) instanceof PrivateKey)) {
                String msg = "Key is not a private key, alias: [" + identifier + "]";
                String logMsg = Merlin.createKeyStoreErrorMessage(this.keystore);
                LOG.error(msg + logMsg);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{msg});
            }
            return (PrivateKey)keyTmp;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex, "noPrivateKey", new Object[]{ex.getMessage()});
        }
    }

    @Override
    public PrivateKey getPrivateKey(String identifier, String password) throws WSSecurityException {
        if (this.keystore == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"The keystore is null"});
        }
        try {
            Key keyTmp;
            if (identifier == null || !this.keystore.isKeyEntry(identifier)) {
                String msg = "Cannot find key for alias: [" + identifier + "]";
                String logMsg = Merlin.createKeyStoreErrorMessage(this.keystore);
                LOG.error(msg + logMsg);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{msg});
            }
            if (password == null && this.privatePasswordSet) {
                password = this.properties.getProperty("org.apache.wss4j.crypto.merlin.keystore.private.password");
                if (password == null) {
                    password = this.properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.private.password");
                }
                if (password != null) {
                    password = password.trim();
                }
            }
            if (!((keyTmp = this.keystore.getKey(identifier, password == null ? new char[]{} : password.toCharArray())) instanceof PrivateKey)) {
                String msg = "Key is not a private key, alias: [" + identifier + "]";
                String logMsg = Merlin.createKeyStoreErrorMessage(this.keystore);
                LOG.error(msg + logMsg);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{msg});
            }
            return (PrivateKey)keyTmp;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex, "noPrivateKey", new Object[]{ex.getMessage()});
        }
    }

    @Override
    public void verifyTrust(X509Certificate[] certs, boolean enableRevocation, Collection<Pattern> subjectCertConstraints) throws WSSecurityException {
        X509Certificate[] foundCerts;
        CryptoType cryptoType;
        if (certs.length == 1 && !enableRevocation) {
            String issuerString = certs[0].getIssuerX500Principal().getName();
            BigInteger issuerSerial = certs[0].getSerialNumber();
            cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
            cryptoType.setIssuerSerial(issuerString, issuerSerial);
            foundCerts = this.getX509Certificates(cryptoType);
            if (foundCerts != null && foundCerts[0] != null && foundCerts[0].equals(certs[0])) {
                try {
                    certs[0].checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, e, "invalidCert");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Direct trust for certificate with " + certs[0].getSubjectX500Principal().getName());
                }
                return;
            }
        }
        X509Certificate[] x509certs = certs;
        String issuerString = certs[0].getIssuerX500Principal().getName();
        if (certs.length == 1) {
            cryptoType = new CryptoType(CryptoType.TYPE.SUBJECT_DN);
            cryptoType.setSubjectDN(issuerString);
            foundCerts = this.getX509Certificates(cryptoType);
            if (foundCerts == null || foundCerts.length < 1) {
                String subjectString = certs[0].getSubjectX500Principal().getName();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No certs found in keystore for issuer " + issuerString + " of certificate for " + subjectString);
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "certpath", new Object[]{"No trusted certs found"});
            }
            x509certs = new X509Certificate[foundCerts.length + 1];
            x509certs[0] = certs[0];
            System.arraycopy(foundCerts, 0, x509certs, 1, foundCerts.length);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preparing to validate certificate path for issuer " + issuerString);
        }
        try {
            TrustAnchor anchor;
            X509Certificate cert;
            String alias;
            List<X509Certificate> certList = Arrays.asList(x509certs);
            CertPath path = this.getCertificateFactory().generateCertPath(certList);
            HashSet<TrustAnchor> set = new HashSet<TrustAnchor>();
            if (this.truststore != null) {
                Enumeration<String> truststoreAliases = this.truststore.aliases();
                while (truststoreAliases.hasMoreElements()) {
                    alias = truststoreAliases.nextElement();
                    cert = (X509Certificate)this.truststore.getCertificate(alias);
                    if (cert == null) continue;
                    anchor = new TrustAnchor(cert, cert.getExtensionValue("2.5.29.30"));
                    set.add(anchor);
                }
            }
            if (this.keystore != null && (this.truststore == null || this.loadCACerts)) {
                Enumeration<String> aliases = this.keystore.aliases();
                while (aliases.hasMoreElements()) {
                    alias = aliases.nextElement();
                    cert = (X509Certificate)this.keystore.getCertificate(alias);
                    if (cert == null) continue;
                    anchor = new TrustAnchor(cert, cert.getExtensionValue("2.5.29.30"));
                    set.add(anchor);
                }
            }
            String provider = this.getCryptoProvider();
            CertPathValidator validator = null;
            validator = provider == null || provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", provider);
            PKIXParameters param = this.createPKIXParameters(set, enableRevocation);
            validator.validate(path, param);
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertPathValidatorException | CertificateException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "certpath");
        }
        if (!this.matches(certs[0], subjectCertConstraints)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
    }

    protected PKIXParameters createPKIXParameters(Set<TrustAnchor> trustAnchors, boolean enableRevocation) throws InvalidAlgorithmParameterException {
        PKIXParameters param = new PKIXParameters(trustAnchors);
        param.setRevocationEnabled(enableRevocation);
        if (enableRevocation && this.crlCertStore != null) {
            param.addCertStore(this.crlCertStore);
        }
        return param;
    }

    @Override
    public void verifyTrust(PublicKey publicKey) throws WSSecurityException {
        if (publicKey == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        if (!this.findPublicKeyInKeyStore(publicKey, this.keystore) && !this.findPublicKeyInKeyStore(publicKey, this.truststore)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
    }

    private X509Certificate[] getX509Certificates(String issuer, BigInteger serialNumber) throws WSSecurityException {
        Object issuerName = null;
        try {
            X500Principal issuerRDN = new X500Principal(issuer);
            issuerName = this.createBCX509Name(issuerRDN.getName());
        }
        catch (IllegalArgumentException ex) {
            issuerName = this.createBCX509Name(issuer);
        }
        Certificate[] certs = null;
        if (this.keystore != null) {
            certs = this.getCertificates(issuerName, serialNumber, this.keystore);
        }
        if ((certs == null || certs.length == 0) && this.truststore != null) {
            certs = this.getCertificates(issuerName, serialNumber, this.truststore);
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private Certificate[] getCertificates(Object issuerRDN, BigInteger serialNumber, KeyStore store) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                Object certName;
                X509Certificate x509cert;
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = store.getCertificateChain(alias);
                if ((certs == null || certs.length == 0) && (cert = store.getCertificate(alias)) != null) {
                    certs = new Certificate[]{cert};
                }
                if (certs == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate) || (x509cert = (X509Certificate)certs[0]).getSerialNumber().compareTo(serialNumber) != 0 || !(certName = this.createBCX509Name(x509cert.getIssuerX500Principal().getName())).equals(issuerRDN)) continue;
                return certs;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "keystore");
        }
        return new Certificate[0];
    }

    private X509Certificate[] getX509Certificates(byte[] thumbprint) throws WSSecurityException {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "decoding.general");
        }
        Certificate[] certs = null;
        if (this.keystore != null) {
            certs = this.getCertificates(thumbprint, this.keystore, sha);
        }
        if ((certs == null || certs.length == 0) && this.truststore != null) {
            certs = this.getCertificates(thumbprint, this.truststore, sha);
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private Certificate[] getCertificates(byte[] thumbprint, KeyStore store, MessageDigest sha) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = store.getCertificateChain(alias);
                if ((certs == null || certs.length == 0) && (cert = store.getCertificate(alias)) != null) {
                    certs = new Certificate[]{cert};
                }
                if (certs == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate)) continue;
                X509Certificate x509cert = (X509Certificate)certs[0];
                try {
                    sha.update(x509cert.getEncoded());
                }
                catch (CertificateEncodingException ex) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, ex, "encodeError");
                }
                byte[] data = sha.digest();
                if (!Arrays.equals(data, thumbprint)) continue;
                return certs;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "keystore");
        }
        return new Certificate[0];
    }

    private X509Certificate[] getX509CertificatesSKI(byte[] skiBytes) throws WSSecurityException {
        Certificate[] certs = null;
        if (this.keystore != null) {
            certs = this.getCertificates(skiBytes, this.keystore);
        }
        if ((certs == null || certs.length == 0) && this.truststore != null) {
            certs = this.getCertificates(skiBytes, this.truststore);
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private Certificate[] getCertificates(byte[] skiBytes, KeyStore store) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                X509Certificate x509cert;
                byte[] data;
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = store.getCertificateChain(alias);
                if ((certs == null || certs.length == 0) && (cert = store.getCertificate(alias)) != null) {
                    certs = new Certificate[]{cert};
                }
                if (certs == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate) || (data = this.getSKIBytesFromCert(x509cert = (X509Certificate)certs[0])).length != skiBytes.length || !Arrays.equals(data, skiBytes)) continue;
                return certs;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "keystore");
        }
        return new Certificate[0];
    }

    private X509Certificate[] getX509CertificatesSubjectDN(String subjectDN) throws WSSecurityException {
        Object subject;
        try {
            X500Principal subjectRDN = new X500Principal(subjectDN);
            subject = this.createBCX509Name(subjectRDN.getName());
        }
        catch (IllegalArgumentException ex) {
            subject = this.createBCX509Name(subjectDN);
        }
        Certificate[] certs = null;
        if (this.keystore != null) {
            certs = this.getCertificates(subject, this.keystore);
        }
        if ((certs == null || certs.length == 0) && this.truststore != null) {
            certs = this.getCertificates(subject, this.truststore);
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private X509Certificate[] getX509Certificates(String identifier) throws WSSecurityException {
        Certificate[] certs = null;
        try {
            Certificate cert;
            if (this.keystore != null && ((certs = this.keystore.getCertificateChain(identifier)) == null || certs.length == 0) && (cert = this.keystore.getCertificate(identifier)) != null) {
                certs = new Certificate[]{cert};
            }
            if (certs == null && this.truststore != null && (certs = this.truststore.getCertificateChain(identifier)) == null && (cert = this.truststore.getCertificate(identifier)) != null) {
                certs = new Certificate[]{cert};
            }
            if (certs == null) {
                return null;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "keystore");
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private boolean findPublicKeyInKeyStore(PublicKey publicKey, KeyStore keyStoreToSearch) {
        if (keyStoreToSearch == null) {
            return false;
        }
        try {
            Enumeration<String> e = keyStoreToSearch.aliases();
            while (e.hasMoreElements()) {
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = keyStoreToSearch.getCertificateChain(alias);
                if ((certs == null || certs.length == 0) && (cert = keyStoreToSearch.getCertificate(alias)) != null) {
                    certs = new Certificate[]{cert};
                }
                if (certs == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate) || !publicKey.equals(((X509Certificate)certs[0]).getPublicKey())) continue;
                return true;
            }
        }
        catch (KeyStoreException e) {
            return false;
        }
        return false;
    }

    private Certificate[] getCertificates(Object subjectRDN, KeyStore store) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                X500Principal foundRDN;
                Object certName;
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = store.getCertificateChain(alias);
                if ((certs == null || certs.length == 0) && (cert = store.getCertificate(alias)) != null) {
                    certs = new Certificate[]{cert};
                }
                if (certs == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate) || !subjectRDN.equals(certName = this.createBCX509Name((foundRDN = ((X509Certificate)certs[0]).getSubjectX500Principal()).getName()))) continue;
                return certs;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "keystore");
        }
        return new Certificate[0];
    }

    private static String createKeyStoreErrorMessage(KeyStore keystore) throws KeyStoreException {
        Enumeration<String> aliases = keystore.aliases();
        StringBuilder sb = new StringBuilder(keystore.size() * 7);
        boolean firstAlias = true;
        while (aliases.hasMoreElements()) {
            if (!firstAlias) {
                sb.append(", ");
            }
            sb.append(aliases.nextElement());
            firstAlias = false;
        }
        String msg = " in keystore of type [" + keystore.getType() + "] from provider [" + keystore.getProvider() + "] with size [" + keystore.size() + "] and aliases: {" + sb.toString() + "}";
        return msg;
    }

    private String getIdentifier(X509Certificate cert, KeyStore store) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                Certificate retrievedCert;
                String alias = e.nextElement();
                Certificate[] certs = store.getCertificateChain(alias);
                if ((certs == null || certs.length == 0) && (retrievedCert = store.getCertificate(alias)) != null) {
                    certs = new Certificate[]{retrievedCert};
                }
                if (certs == null || certs.length <= 0 || !certs[0].equals(cert)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "keystore");
        }
        return null;
    }

    private String getPassword(String identifier, CallbackHandler cb) throws WSSecurityException {
        WSPasswordCallback pwCb = new WSPasswordCallback(identifier, 1);
        try {
            Callback[] callbacks = new Callback[]{pwCb};
            cb.handle(callbacks);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "noPassword", new Object[]{identifier});
        }
        return pwCb.getPassword();
    }

    protected String decryptPassword(String password, PasswordEncryptor passwordEncryptor) {
        if (password.startsWith(ENCRYPTED_PASSWORD_PREFIX) && password.endsWith(ENCRYPTED_PASSWORD_SUFFIX)) {
            if (passwordEncryptor == null) {
                String error = "The Crypto properties has an encrypted password, but no PasswordEncryptor is configured!";
                LOG.debug(error);
                return password;
            }
            String substring = password.substring(ENCRYPTED_PASSWORD_PREFIX.length(), password.length() - 1);
            return passwordEncryptor.decrypt(substring);
        }
        return password;
    }

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }
}

