/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.saml;

import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLBootstrap;
import org.opensaml.core.config.Configuration;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.provider.MapBasedConfiguration;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLConfigurationException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.config.SAMLConfiguration;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public final class OpenSAMLUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSAMLUtil.class);
    private static XMLObjectBuilderFactory builderFactory;
    private static MarshallerFactory marshallerFactory;
    private static UnmarshallerFactory unmarshallerFactory;
    private static boolean samlEngineInitialized;

    private OpenSAMLUtil() {
    }

    public static synchronized void initSamlEngine() {
        if (!samlEngineInitialized) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initializing the opensaml2 library...");
            }
            WSProviderConfig.init();
            MapBasedConfiguration configuration = new MapBasedConfiguration();
            ConfigurationService.setConfiguration((Configuration)configuration);
            XMLObjectProviderRegistry providerRegistry = new XMLObjectProviderRegistry();
            configuration.register(XMLObjectProviderRegistry.class, (Object)providerRegistry, "default");
            try {
                OpenSAMLBootstrap.bootstrap();
                SAMLConfiguration samlConfiguration = new SAMLConfiguration();
                configuration.register(SAMLConfiguration.class, (Object)samlConfiguration, "default");
                builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
                marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
                unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
                samlEngineInitialized = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("opensaml3 library bootstrap complete");
                }
            }
            catch (XMLConfigurationException ex) {
                LOG.error("Unable to bootstrap the opensaml3 library - all SAML operations will fail", (Throwable)ex);
            }
        }
    }

    public static XMLObject fromDom(Element root) throws WSSecurityException {
        if (root == null) {
            LOG.debug("Attempting to unmarshal a null element!");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", "Error unmarshalling a SAML assertion");
        }
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(root);
        if (unmarshaller == null) {
            LOG.debug("Unable to find an unmarshaller for element: " + root.getLocalName());
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", "Error unmarshalling a SAML assertion");
        }
        try {
            return unmarshaller.unmarshall(root);
        }
        catch (UnmarshallingException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", (Exception)((Object)ex), "Error unmarshalling a SAML assertion");
        }
    }

    public static Element toDom(XMLObject xmlObject, Document doc) throws WSSecurityException {
        return OpenSAMLUtil.toDom(xmlObject, doc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element toDom(XMLObject xmlObject, Document doc, boolean signObject) throws WSSecurityException {
        Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
        Element element = null;
        DocumentFragment frag = doc == null ? null : doc.createDocumentFragment();
        try {
            if (frag != null) {
                while (doc.getFirstChild() != null) {
                    frag.appendChild(doc.removeChild(doc.getFirstChild()));
                }
            }
            try {
                element = doc == null ? marshaller.marshall(xmlObject) : marshaller.marshall(xmlObject, doc);
            }
            catch (MarshallingException ex) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", (Exception)((Object)ex), "Error marshalling a SAML assertion");
            }
            if (signObject) {
                OpenSAMLUtil.signXMLObject(xmlObject);
            }
        }
        finally {
            if (frag != null) {
                while (doc.getFirstChild() != null) {
                    doc.removeChild(doc.getFirstChild());
                }
                doc.appendChild(frag);
            }
        }
        return element;
    }

    private static void signXMLObject(XMLObject xmlObject) throws WSSecurityException {
        if (xmlObject instanceof Response) {
            Response response = (Response)xmlObject;
            if (response.getAssertions() != null) {
                for (Assertion assertion : response.getAssertions()) {
                    OpenSAMLUtil.signObject(assertion.getSignature());
                }
            }
            OpenSAMLUtil.signObject(response.getSignature());
        } else if (xmlObject instanceof org.opensaml.saml.saml2.core.Response) {
            org.opensaml.saml.saml2.core.Response response = (org.opensaml.saml.saml2.core.Response)xmlObject;
            if (response.getAssertions() != null) {
                for (org.opensaml.saml.saml2.core.Assertion assertion : response.getAssertions()) {
                    OpenSAMLUtil.signObject(assertion.getSignature());
                }
            }
            OpenSAMLUtil.signObject(response.getSignature());
        } else if (xmlObject instanceof org.opensaml.saml.saml2.core.Assertion) {
            org.opensaml.saml.saml2.core.Assertion saml2 = (org.opensaml.saml.saml2.core.Assertion)xmlObject;
            OpenSAMLUtil.signObject(saml2.getSignature());
        } else if (xmlObject instanceof Assertion) {
            Assertion saml1 = (Assertion)xmlObject;
            OpenSAMLUtil.signObject(saml1.getSignature());
        } else if (xmlObject instanceof RequestAbstractType) {
            RequestAbstractType request = (RequestAbstractType)xmlObject;
            OpenSAMLUtil.signObject(request.getSignature());
        } else if (xmlObject instanceof Request) {
            Request request = (Request)xmlObject;
            OpenSAMLUtil.signObject(request.getSignature());
        }
    }

    private static void signObject(Signature signature) throws WSSecurityException {
        if (signature != null) {
            try {
                Signer.signObject((Signature)signature);
            }
            catch (SignatureException ex) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", (Exception)((Object)ex), "Error signing a SAML assertion");
            }
        }
    }

    public static Signature buildSignature() {
        QName qName = Signature.DEFAULT_ELEMENT_NAME;
        XMLObjectBuilder builder = builderFactory.getBuilder(qName);
        if (builder == null) {
            LOG.error("Unable to retrieve builder for object QName " + qName);
            return null;
        }
        return (Signature)builder.buildObject(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
    }

    public static boolean isMethodSenderVouches(String confirmMethod) {
        return confirmMethod != null && confirmMethod.startsWith("urn:oasis:names:tc:SAML:") && confirmMethod.endsWith(":cm:sender-vouches");
    }

    public static boolean isMethodHolderOfKey(String confirmMethod) {
        return confirmMethod != null && confirmMethod.startsWith("urn:oasis:names:tc:SAML:") && confirmMethod.endsWith(":cm:holder-of-key");
    }

    static {
        samlEngineInitialized = false;
    }
}

