/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.ts.xml.XMLSample;
import org.codehaus.stax2.DTDInfo;

final class XMLSampleProperties {
    private static final XMLInputFactory inputFactory = new WstxInputFactory();
    private final String encoding;
    private final boolean hasDTD;
    private final boolean hasExternalSubset;
    private final boolean hasInternalSubset;
    private final boolean hasEntityReferences;

    XMLSampleProperties(XMLSample sample) {
        boolean hasDTD = false;
        boolean hasExternalSubset = false;
        boolean hasInternalSubset = false;
        boolean hasEntityReferences = false;
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(new StreamSource(sample.getUrl().toString()));
            this.encoding = reader.getEncoding();
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 11: {
                        hasDTD = true;
                        hasInternalSubset = reader.getText().length() > 0;
                        hasExternalSubset = ((DTDInfo)reader).getDTDSystemId() != null;
                        break;
                    }
                    case 9: {
                        hasEntityReferences = true;
                    }
                }
            }
            reader.close();
        }
        catch (XMLStreamException ex) {
            throw new Error("Unable to parse " + sample.getUrl(), ex);
        }
        this.hasDTD = hasDTD;
        this.hasExternalSubset = hasExternalSubset;
        this.hasInternalSubset = hasInternalSubset;
        this.hasEntityReferences = hasEntityReferences;
    }

    String getEncoding() {
        return this.encoding;
    }

    boolean hasDTD() {
        return this.hasDTD;
    }

    boolean hasExternalSubset() {
        return this.hasExternalSubset;
    }

    boolean hasInternalSubset() {
        return this.hasInternalSubset;
    }

    boolean hasEntityReferences() {
        return this.hasEntityReferences;
    }

    static {
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
    }
}

