/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.xml;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.testutils.io.InstrumentedInputStream;
import org.apache.axiom.testutils.io.InstrumentedReader;
import org.apache.axiom.testutils.io.InstrumentedStream;
import org.apache.axiom.ts.xml.XMLSample;

public abstract class StreamType
extends Multiton {
    public static final StreamType BYTE_STREAM = new StreamType(InputStream.class){

        @Override
        public Closeable getStream(XMLSample sample) {
            return sample.getInputStream();
        }

        @Override
        public InstrumentedStream instrumentStream(Closeable stream) {
            return new InstrumentedInputStream((InputStream)stream);
        }

        @Override
        public XMLStreamReader createXMLStreamReader(XMLInputFactory factory, Closeable stream) throws XMLStreamException {
            return factory.createXMLStreamReader((InputStream)stream);
        }

        @Override
        public StreamSource createStreamSource(Closeable stream) {
            return new StreamSource((InputStream)stream);
        }
    };
    public static final StreamType CHARACTER_STREAM = new StreamType(Reader.class){

        @Override
        public Closeable getStream(XMLSample sample) {
            return new InputStreamReader(sample.getInputStream(), Charset.forName(sample.getEncoding()));
        }

        @Override
        public InstrumentedStream instrumentStream(Closeable stream) {
            return new InstrumentedReader((Reader)stream);
        }

        @Override
        public XMLStreamReader createXMLStreamReader(XMLInputFactory factory, Closeable stream) throws XMLStreamException {
            return factory.createXMLStreamReader((Reader)stream);
        }

        @Override
        public StreamSource createStreamSource(Closeable stream) {
            return new StreamSource((Reader)stream);
        }
    };
    private final Class<? extends Closeable> type;

    private StreamType(Class<? extends Closeable> type) {
        this.type = type;
    }

    public final Class<? extends Closeable> getType() {
        return this.type;
    }

    public abstract Closeable getStream(XMLSample var1);

    public abstract InstrumentedStream instrumentStream(Closeable var1);

    public abstract XMLStreamReader createXMLStreamReader(XMLInputFactory var1, Closeable var2) throws XMLStreamException;

    public abstract StreamSource createStreamSource(Closeable var1);
}

