/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.jaxp.xslt;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.ts.jaxp.xslt.TestContentHandler;
import org.apache.xalan.processor.TransformerFactoryImpl;

public abstract class XSLTImplementation
extends Multiton {
    public static final XSLTImplementation JRE = new XSLTImplementation("jre"){

        @Override
        public TransformerFactory newTransformerFactory() {
            return TransformerFactory.newDefaultInstance();
        }
    };
    public static final XSLTImplementation XALAN = new XSLTImplementation("xalan"){

        @Override
        public TransformerFactory newTransformerFactory() {
            return new TransformerFactoryImpl();
        }
    };
    public static final XSLTImplementation SAXON = new XSLTImplementation("saxon"){

        @Override
        public TransformerFactory newTransformerFactory() {
            return new net.sf.saxon.TransformerFactoryImpl();
        }
    };
    private final String name;
    private Boolean supportsLexicalHandlerWithStreamSource;
    private Boolean supportsStAXSource;

    private XSLTImplementation(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public abstract TransformerFactory newTransformerFactory();

    public final synchronized boolean supportsLexicalHandlerWithStreamSource() {
        if (this.supportsLexicalHandlerWithStreamSource == null) {
            StreamSource source = new StreamSource(new StringReader("<!DOCTYPE root><root><![CDATA[test]]></root>"));
            TestContentHandler handler = new TestContentHandler();
            SAXResult result = new SAXResult(handler);
            result.setLexicalHandler(handler);
            try {
                this.newTransformerFactory().newTransformer().transform(source, result);
            }
            catch (TransformerException ex) {
                throw new RuntimeException(ex);
            }
            this.supportsLexicalHandlerWithStreamSource = handler.getLexicalEventsReceived() == 4;
        }
        return this.supportsLexicalHandlerWithStreamSource;
    }

    public final synchronized boolean supportsStAXSource() {
        if (this.supportsStAXSource == null) {
            try {
                StAXSource source = new StAXSource(XMLInputFactory.newInstance().createXMLStreamReader(new StringReader("<root/>")));
                StreamResult result = new StreamResult(new ByteArrayOutputStream());
                this.newTransformerFactory().newTransformer().transform(source, result);
                this.supportsStAXSource = true;
            }
            catch (Exception ex) {
                this.supportsStAXSource = false;
            }
        }
        return this.supportsStAXSource;
    }
}

