/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.jaxp.stax;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.axiom.testing.multiton.Instances;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.ts.jaxp.stax.ParentLastURLClassLoader;
import org.apache.commons.io.IOUtils;

public abstract class StAXImplementation
extends Multiton {
    public static final StAXImplementation JRE = new StAXImplementation("JRE"){

        @Override
        public XMLInputFactory newXMLInputFactory() {
            return XMLInputFactory.newDefaultFactory();
        }

        @Override
        public XMLOutputFactory newXMLOutputFactory() {
            return XMLOutputFactory.newDefaultFactory();
        }
    };
    private final String name;

    private StAXImplementation(String name) {
        this.name = name;
    }

    private static File extractJar(String jarName) throws IOException {
        File jar = File.createTempFile(jarName, ".jar");
        try (InputStream in = StAXImplementation.class.getResourceAsStream(jarName);
             FileOutputStream out = new FileOutputStream(jar);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String jarName) throws IOException {
        InputStream in;
        int delimiterIndex = jarName.length();
        while (true) {
            if (delimiterIndex-- == 0) {
                return null;
            }
            char c = jarName.charAt(delimiterIndex);
            if (c != '.' && c != '_' && c != '-') continue;
            in = StAXImplementation.class.getResourceAsStream(jarName.substring(0, delimiterIndex) + ".properties");
            if (in != null) break;
        }
        try {
            Properties props = new Properties();
            props.load(in);
            Properties properties = props;
            return properties;
        }
        finally {
            in.close();
        }
    }

    @Instances
    private static StAXImplementation[] instances() throws Exception {
        ArrayList<2> instances = new ArrayList<2>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(StAXImplementation.class.getResourceAsStream("filelist")));){
            String jarName;
            while ((jarName = in.readLine()) != null) {
                File jar = StAXImplementation.extractJar(jarName);
                final ParentLastURLClassLoader classLoader = new ParentLastURLClassLoader(new URL[]{jar.toURI().toURL()}, StAXImplementation.class.getClassLoader());
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    IOUtils.closeQuietly((Closeable)classLoader);
                    jar.delete();
                }));
                final Properties props = StAXImplementation.loadProperties(jarName);
                instances.add(new StAXImplementation(jarName){

                    private <T> T newFactory(Class<T> type) {
                        String className;
                        if (props != null && (className = props.getProperty(type.getName())) != null) {
                            try {
                                return classLoader.loadClass(className).asSubclass(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (ReflectiveOperationException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        return ServiceLoader.load(type, classLoader).findFirst().get();
                    }

                    @Override
                    public XMLInputFactory newXMLInputFactory() {
                        return this.newFactory(XMLInputFactory.class);
                    }

                    @Override
                    public XMLOutputFactory newXMLOutputFactory() {
                        return this.newFactory(XMLOutputFactory.class);
                    }
                });
            }
        }
        return instances.toArray(new StAXImplementation[instances.size()]);
    }

    public final String getName() {
        return this.name;
    }

    public abstract XMLInputFactory newXMLInputFactory();

    public abstract XMLOutputFactory newXMLOutputFactory();
}

