/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.jaxp.stax;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;

public class ParentLastURLClassLoader
extends URLClassLoader {
    public ParentLastURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> resources = new Vector<URL>();
        Enumeration<URL> e = this.findResources(name);
        while (e.hasMoreElements()) {
            resources.add(e.nextElement());
        }
        e = this.getParent().getResources(name);
        while (e.hasMoreElements()) {
            resources.add(e.nextElement());
        }
        return resources.elements();
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("javax.")) {
            return super.loadClass(name, resolve);
        }
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.getParent().loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

