/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.jaxp.dom;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class DOMImplementation
extends Multiton {
    public static final DOMImplementation XERCES = new DOMImplementation("xerces", true, true){

        @Override
        protected DocumentBuilderFactory newDocumentBuilderFactory() {
            return new DocumentBuilderFactoryImpl();
        }
    };
    public static final DOMImplementation CRIMSON = new DOMImplementation("crimson", false, false){

        @Override
        protected DocumentBuilderFactory newDocumentBuilderFactory() {
            return new org.apache.crimson.jaxp.DocumentBuilderFactoryImpl();
        }
    };
    private final String name;
    private final boolean dom3;
    private final boolean internalSubset;

    private DOMImplementation(String name, boolean dom3, boolean internalSubset) {
        this.name = name;
        this.dom3 = dom3;
        this.internalSubset = internalSubset;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDOM3() {
        return this.dom3;
    }

    public final boolean supportsGetInternalSubset() {
        return this.internalSubset;
    }

    protected abstract DocumentBuilderFactory newDocumentBuilderFactory();

    public final Document newDocument() {
        try {
            return this.newDocumentBuilderFactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new Error("Unexpected exception", ex);
        }
    }

    public final Document parse(InputSource is) throws SAXException, IOException {
        return this.parse(is, true);
    }

    public final Document parse(InputSource is, boolean expandEntityReferences) throws SAXException, IOException {
        Document document;
        DocumentBuilderFactory factory = this.newDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(expandEntityReferences);
        try {
            document = factory.newDocumentBuilder().parse(is);
        }
        catch (ParserConfigurationException ex) {
            throw new Error("Unexpected exception", ex);
        }
        if (!expandEntityReferences) {
            this.expandPredefinedEntityReferences(document.getDocumentElement());
        }
        return document;
    }

    private void expandPredefinedEntityReferences(Element element) {
        block4: for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    this.expandPredefinedEntityReferences((Element)child);
                    continue block4;
                }
                case 5: {
                    if (!child.getNodeName().equals("lt")) continue block4;
                    Text content = (Text)child.getFirstChild().cloneNode(false);
                    element.replaceChild(content, child);
                    child = content;
                }
            }
        }
    }

    public final Document parse(InputStream in) throws SAXException, IOException {
        return this.parse(new InputSource(in));
    }
}

