/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.jaxp;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.axiom.testing.multiton.Instances;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.ts.jaxp.TestContentHandler;

public abstract class XSLTImplementation
extends Multiton {
    private static final String[] jreTransformerFactoryClassNames = new String[]{"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl"};
    public static final XSLTImplementation XALAN = new XSLTImplementation("xalan"){

        @Override
        public TransformerFactory newTransformerFactory() {
            return new org.apache.xalan.processor.TransformerFactoryImpl();
        }
    };
    public static final XSLTImplementation SAXON = new XSLTImplementation("saxon"){

        @Override
        public TransformerFactory newTransformerFactory() {
            return new TransformerFactoryImpl();
        }
    };
    private final String name;
    private Boolean supportsLexicalHandlerWithStreamSource;
    private Boolean supportsStAXSource;

    private XSLTImplementation(String name) {
        this.name = name;
    }

    @Instances
    private static XSLTImplementation[] instances() {
        for (String className : jreTransformerFactoryClassNames) {
            try {
                final Class<TransformerFactory> clazz = Class.forName(className).asSubclass(TransformerFactory.class);
                XSLTImplementation implementation = new XSLTImplementation("jre"){

                    @Override
                    public TransformerFactory newTransformerFactory() {
                        try {
                            return (TransformerFactory)clazz.newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                };
                return new XSLTImplementation[]{implementation};
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return new XSLTImplementation[0];
    }

    public final String getName() {
        return this.name;
    }

    public abstract TransformerFactory newTransformerFactory();

    public final synchronized boolean supportsLexicalHandlerWithStreamSource() {
        if (this.supportsLexicalHandlerWithStreamSource == null) {
            StreamSource source = new StreamSource(new StringReader("<!DOCTYPE root><root><![CDATA[test]]></root>"));
            TestContentHandler handler = new TestContentHandler();
            SAXResult result = new SAXResult(handler);
            result.setLexicalHandler(handler);
            try {
                this.newTransformerFactory().newTransformer().transform(source, result);
            }
            catch (TransformerException ex) {
                throw new RuntimeException(ex);
            }
            this.supportsLexicalHandlerWithStreamSource = handler.getLexicalEventsReceived() == 4;
        }
        return this.supportsLexicalHandlerWithStreamSource;
    }

    public final synchronized boolean supportsStAXSource() {
        if (this.supportsStAXSource == null) {
            try {
                StAXSource source = new StAXSource(XMLInputFactory.newInstance().createXMLStreamReader(new StringReader("<root/>")));
                StreamResult result = new StreamResult(new ByteArrayOutputStream());
                this.newTransformerFactory().newTransformer().transform(source, result);
                this.supportsStAXSource = true;
            }
            catch (Exception ex) {
                this.supportsStAXSource = false;
            }
        }
        return this.supportsStAXSource;
    }
}

