/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.servlet.contentencode;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentEncodingRequestFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ContentEncodingRequestFilter.class);

    public void init(FilterConfig arg0) throws ServletException {
        logger.trace("init({}) entry", (Object)arg0);
        logger.trace("init() exit");
    }

    public void destroy() {
        logger.trace("destroy() entry");
        logger.trace("destroy() exit");
    }

    private String getContentEncoding(HttpServletRequest httpServletRequest) {
        String contentEncoding = httpServletRequest.getHeader("Content-Encoding");
        if (contentEncoding == null) {
            return null;
        }
        contentEncoding.trim();
        return contentEncoding;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (logger.isTraceEnabled()) {
            logger.trace("doFilter({}, {}, {}) entry", new Object[]{servletRequest, servletResponse, chain});
        }
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            Object httpServletRequest = (HttpServletRequest)servletRequest;
            String contentEncoding = this.getContentEncoding((HttpServletRequest)httpServletRequest);
            logger.trace("Content-Encoding was {}", (Object)contentEncoding);
            if (contentEncoding != null && ("gzip".equals(contentEncoding) || "deflate".equals(contentEncoding))) {
                logger.trace("Wrapping HttpServletRequest because Content-Encoding was set to gzip or deflate");
                httpServletRequest = new HttpServletRequestContentEncodingWrapperImpl((HttpServletRequest)httpServletRequest, contentEncoding);
                logger.trace("Invoking chain with wrapped HttpServletRequest");
                chain.doFilter((ServletRequest)httpServletRequest, servletResponse);
                logger.trace("doFilter exit()");
                return;
            }
        }
        logger.trace("Invoking normal chain since Content-Encoding request header was not understood");
        chain.doFilter(servletRequest, servletResponse);
        logger.trace("doFilter exit()");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HttpServletRequestContentEncodingWrapperImpl
    extends HttpServletRequestWrapper {
        private ServletInputStream inputStream;
        private final String contentEncoding;

        public HttpServletRequestContentEncodingWrapperImpl(HttpServletRequest request, String contentEncoding) {
            super(request);
            this.contentEncoding = contentEncoding;
        }

        public ServletInputStream getInputStream() throws IOException {
            logger.trace("getInputStream() entry");
            if (this.inputStream == null) {
                this.inputStream = super.getInputStream();
                if ("gzip".equals(this.contentEncoding)) {
                    logger.trace("Wrapping ServletInputStream with GZIPDecoder");
                    this.inputStream = new GZIPDecoderInputStream((InputStream)this.inputStream);
                } else if ("deflate".equals(this.contentEncoding)) {
                    logger.trace("Wrapping ServletInputStream with Inflater");
                    this.inputStream = new InflaterDecoderInputStream((InputStream)this.inputStream);
                }
            }
            logger.trace("getInputStream() exit - returning {}", (Object)this.inputStream);
            return this.inputStream;
        }

        public String getHeader(String name) {
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return null;
            }
            return super.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return new Enumeration<String>(){

                    @Override
                    public boolean hasMoreElements() {
                        return false;
                    }

                    @Override
                    public String nextElement() {
                        return null;
                    }
                };
            }
            return super.getHeaders(name);
        }

        public Enumeration getHeaderNames() {
            Enumeration headers = super.getHeaderNames();
            ArrayList<String> httpHeaders = new ArrayList<String>();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                if ("Content-Encoding".equalsIgnoreCase(header)) continue;
                httpHeaders.add(header);
            }
            final Iterator iterator = httpHeaders.iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)iterator.next();
                }
            };
        }
    }

    static class InflaterDecoderInputStream
    extends DecoderServletInputStream {
        public InflaterDecoderInputStream(InputStream is) {
            super(new InflaterInputStream(is));
        }
    }

    static class GZIPDecoderInputStream
    extends DecoderServletInputStream {
        public GZIPDecoderInputStream(InputStream is) throws IOException {
            super(new GZIPInputStream(is));
        }
    }

    static class DecoderServletInputStream
    extends ServletInputStream {
        private final InputStream is;

        public DecoderServletInputStream(InputStream is) {
            this.is = is;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void close() throws IOException {
            this.is.close();
        }

        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }
    }
}

