/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.servlet.RestServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestFilter
implements Filter {
    private RestServlet restServlet;
    private static final Logger logger = LoggerFactory.getLogger(RestFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            FilteredHttpServletResponse httpServletResponse = new FilteredHttpServletResponse((HttpServletResponse)servletResponse);
            this.restServlet.service((HttpServletRequest)servletRequest, (HttpServletResponse)httpServletResponse);
            if (!httpServletResponse.isCommitted() && httpServletResponse.getStatusCode() == 404) {
                logger.trace("Filter {} did not match a resource so letting request continue on FilterChain {}", (Object)this, (Object)chain);
                httpServletResponse.setStatus(200);
                chain.doFilter(servletRequest, servletResponse);
            }
        } else {
            logger.trace("Filter {} did not expect a non-HttpServletRequest and/or non-HttpServletResponse but letting chain continue", (Object)this);
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(final FilterConfig filterConfig) throws ServletException {
        this.restServlet = new RestServletForFilter(filterConfig);
        logger.trace("Initializing RestFilter {} with {} config and {} servlet", new Object[]{this, filterConfig, this.restServlet});
        this.restServlet.init(new ServletConfig(){

            public String getServletName() {
                return filterConfig.getFilterName();
            }

            public ServletContext getServletContext() {
                return filterConfig.getServletContext();
            }

            public Enumeration<?> getInitParameterNames() {
                return filterConfig.getInitParameterNames();
            }

            public String getInitParameter(String paramName) {
                return filterConfig.getInitParameter(paramName);
            }
        });
    }

    public void destroy() {
        logger.trace("Destroying RestFilter {}", (Object)this);
        this.restServlet.destroy();
    }

    protected static class RestServletForFilter
    extends RestServlet {
        protected FilterConfig filterConfig;
        private static final long serialVersionUID = 5230595914609866319L;

        public RestServletForFilter(FilterConfig config) {
            this.filterConfig = config;
        }

        protected DeploymentConfiguration getDeploymentConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
            DeploymentConfiguration deploymentConfiguration = super.getDeploymentConfiguration();
            deploymentConfiguration.setFilterConfig(this.filterConfig);
            return deploymentConfiguration;
        }
    }

    private static class FilteredHttpServletResponse
    extends HttpServletResponseWrapper {
        private static final Logger logger = LoggerFactory.getLogger(FilteredHttpServletResponse.class);
        private int statusCode;

        public FilteredHttpServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int statusCode) {
            super.setStatus(statusCode);
            this.statusCode = statusCode;
            logger.trace("FilteredHttpServletResponse set status code to {}", (Object)statusCode);
        }

        public void setStatus(int statusCode, String msg) {
            super.setStatus(statusCode, msg);
            this.statusCode = statusCode;
            logger.trace("FilteredHttpServletResponse set status code to {}", (Object)statusCode);
        }

        int getStatusCode() {
            return this.statusCode;
        }
    }
}

