/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.resources;

import java.util.LinkedHashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import org.apache.wink.common.categories.Categories;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.utils.UriHelper;
import org.apache.wink.common.model.app.AppAccept;
import org.apache.wink.common.model.app.AppCategories;
import org.apache.wink.common.model.app.AppCollection;
import org.apache.wink.common.model.app.AppService;
import org.apache.wink.common.model.app.AppWorkspace;
import org.apache.wink.common.model.app.AppYesNo;
import org.apache.wink.common.model.atom.AtomCategory;
import org.apache.wink.common.model.atom.AtomText;
import org.apache.wink.server.internal.resources.ServiceDocumentCollectionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/")
public class RootResource {
    @GET
    @Produces(value={"application/atomsvc+xml"})
    public AppService getServiceDocument(@Context UriInfo uriInfo) {
        List<ServiceDocumentCollectionData> serviceDocument = this.getCollections(uriInfo);
        return this.buildAppService(serviceDocument, uriInfo);
    }

    public List<ServiceDocumentCollectionData> getCollections(UriInfo uriInfo) {
        List<ServiceDocumentCollectionData> buildServiceDocumentCollectionList = ServiceDocumentCollectionData.buildServiceDocumentCollectionList(uriInfo);
        return buildServiceDocumentCollectionList;
    }

    private AppService buildAppService(List<ServiceDocumentCollectionData> collectionList, UriInfo uriInfo) {
        if (collectionList == null) {
            throw new NullPointerException(Messages.getMessage((String)"rootResourceCollectionListIsNull"));
        }
        LinkedHashMap<String, AppWorkspace> workspaces = new LinkedHashMap<String, AppWorkspace>();
        AppService appService = new AppService();
        List workspaceList = appService.getWorkspace();
        for (ServiceDocumentCollectionData serviceDocumentCollection : collectionList) {
            String workspaceName = serviceDocumentCollection.getWorkspace();
            AppWorkspace workspace = (AppWorkspace)workspaces.get(workspaceName);
            if (workspace == null) {
                workspace = new AppWorkspace();
                AtomText workspaceTitle = new AtomText();
                workspaceTitle.setValue((Object)workspaceName);
                workspace.setTitle(workspaceTitle);
                workspaces.put(workspaceName, workspace);
                workspaceList.add(workspace);
            }
            String baseUri = uriInfo.getBaseUri().toString();
            this.addCollection(workspace, serviceDocumentCollection, baseUri);
        }
        return appService;
    }

    private void addCollection(AppWorkspace workspace, ServiceDocumentCollectionData serviceDocumentCollection, String baseUri) {
        AppCollection collection = new AppCollection();
        List workspaceCollectionList = workspace.getCollection();
        String href = UriHelper.appendPathToBaseUri((String)baseUri, (String)serviceDocumentCollection.getUri());
        collection.setHref(href);
        AtomText title = new AtomText();
        title.setValue((Object)serviceDocumentCollection.getTitle());
        collection.setTitle(title);
        List acceptMediaTypes = collection.getAccept();
        if (serviceDocumentCollection.getAccepts().isEmpty()) {
            AppAccept appAccept = new AppAccept();
            acceptMediaTypes.add(appAccept);
        } else {
            for (MediaType acceptMediaType : serviceDocumentCollection.getAccepts()) {
                AppAccept appAccept = new AppAccept();
                String appAcceptString = acceptMediaType.toString();
                appAccept.setValue(appAcceptString);
                acceptMediaTypes.add(appAccept);
            }
        }
        this.addCategories(serviceDocumentCollection, collection);
        workspaceCollectionList.add(collection);
    }

    private void addCategories(ServiceDocumentCollectionData serviceDocumentCollection, AppCollection collection) {
        List appCategories = collection.getCategories();
        List<Categories> categories = serviceDocumentCollection.getCategories();
        if (categories == null) {
            return;
        }
        for (Categories cats : categories) {
            AppCategories appCategory = new AppCategories();
            if (cats.isOutOfLine()) {
                String href = cats.getHref();
                appCategory.setHref(href);
            } else {
                this.addInlineCategories(cats, appCategory);
            }
            appCategories.add(appCategory);
        }
    }

    private void addInlineCategories(Categories cats, AppCategories appCategory) {
        boolean fixed;
        List xmlCategoryList = appCategory.getCategory();
        List categoryBeans = cats.getCategories();
        for (AtomCategory cat : categoryBeans) {
            String catTerm;
            String catScheme;
            AtomCategory xmlCategory = new AtomCategory();
            String catLabel = cat.getLabel();
            if (catLabel != null) {
                xmlCategory.setLabel(catLabel);
            }
            if ((catScheme = cat.getScheme()) != null) {
                xmlCategory.setScheme(catScheme);
            }
            if ((catTerm = cat.getTerm()) != null) {
                xmlCategory.setTerm(catTerm);
            }
            xmlCategoryList.add(xmlCategory);
        }
        String catsScheme = cats.getScheme();
        if (catsScheme != null) {
            appCategory.setScheme(catsScheme);
        }
        if (fixed = cats.isFixed()) {
            appCategory.setFixed(AppYesNo.YES);
        }
    }
}

