/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.log;

import java.util.Formatter;
import java.util.List;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Providers {
    private static final String CUSTOM = "Custom?";
    private static final String CONSUMES_MEDIA_TYPE = "Consumes Media Type";
    private static final String PRODUCES_MEDIA_TYPE = "Produces Media Type";
    private static final String PROVIDER_FORMAT_LINE = "%n%1$-35s %2$-25s %3$-8s %4$s";
    private static final String EXCEPTION_MAPPER_FORMAT_LINE = "%n%1$-25s %2$-8s %3$s";
    private static final String PROVIDER_CLASS = "Provider Class";
    private static final String GENERIC_TYPE = "Generic Type";
    private static final int BREAK_POINT = 20;
    private static final Logger logger = LoggerFactory.getLogger(Providers.class);
    private final ProvidersRegistry providersRegistry;

    public Providers(ProvidersRegistry providersRegistry) {
        this.providersRegistry = providersRegistry;
    }

    public void log() {
        try {
            if (logger.isInfoEnabled()) {
                boolean isProviderDefined = false;
                List providerRecords = this.providersRegistry.getMessageBodyReaderRecords();
                boolean temp = this.log(providerRecords, "MessageBodyReader");
                if (temp) {
                    isProviderDefined = true;
                }
                if (temp = this.log(providerRecords = this.providersRegistry.getMessageBodyWriterRecords(), "MessageBodyWriter")) {
                    isProviderDefined = true;
                }
                if (temp = this.log(providerRecords = this.providersRegistry.getExceptionMapperRecords())) {
                    isProviderDefined = true;
                }
                if (temp = this.log(providerRecords = this.providersRegistry.getContextResolverRecords(), "ContextResolver")) {
                    isProviderDefined = true;
                }
                if (isProviderDefined && logger.isDebugEnabled()) {
                    this.logTable();
                }
                if (!isProviderDefined) {
                    logger.info(Messages.getMessage((String)"noJAXRSApplicationDefinedProviders"));
                }
            }
        }
        catch (Exception e) {
            logger.trace("Could not print the entire providers metadata", (Throwable)e);
        }
    }

    private boolean log(List<ProvidersRegistry.ProviderRecord<?>> records, String providerType) {
        if (records != null && !records.isEmpty()) {
            for (ProvidersRegistry.ProviderRecord<?> record : records) {
                if (record.getGenericType() == null || Object.class.equals((Object)record.getGenericType())) {
                    logger.info(Messages.getMessage((String)"registeredJAXRSProviderWithMediaTypeAndAllGenericType", (Object[])new Object[]{record.getProviderClass().getName(), providerType, record.getMediaType()}));
                    continue;
                }
                logger.info(Messages.getMessage((String)"registeredJAXRSProviderWithMediaType", (Object[])new Object[]{record.getProviderClass().getName(), providerType, record.getGenericType().getName(), record.getMediaType()}));
            }
            return true;
        }
        return false;
    }

    private boolean log(List<ProvidersRegistry.ProviderRecord<?>> records) {
        if (records != null && !records.isEmpty()) {
            for (ProvidersRegistry.ProviderRecord<?> record : records) {
                if (record.getGenericType() == null || Object.class.equals((Object)record.getGenericType())) {
                    logger.info(Messages.getMessage((String)"registeredJAXRSProviderWithoutMediaTypeAndAllGenericType", (Object[])new Object[]{record.getProviderClass().getName(), "ExceptionMapper"}));
                    continue;
                }
                logger.info(Messages.getMessage((String)"registeredJAXRSProviderWithoutMediaType", (Object[])new Object[]{record.getProviderClass().getName(), "ExceptionMapper", record.getGenericType().getName()}));
            }
            return true;
        }
        return false;
    }

    private void log(List<ProvidersRegistry.ProviderRecord<?>> providerRecords, String providerType, String mediaTypeHeader) {
        StringBuffer sb = new StringBuffer();
        if (!providerRecords.isEmpty()) {
            Formatter f = new Formatter(sb);
            f.format(PROVIDER_FORMAT_LINE, mediaTypeHeader, GENERIC_TYPE, CUSTOM, PROVIDER_CLASS);
            int counter = 0;
            for (ProvidersRegistry.ProviderRecord<?> record : providerRecords) {
                f.format(PROVIDER_FORMAT_LINE, record.getMediaType(), record.getGenericType().getSimpleName(), !record.isSystemProvider(), record.getProviderClass().getName());
                if (++counter % 20 != 0) continue;
                logger.debug("The following JAX-RS {} providers are registered:{}", (Object)providerType, (Object)sb);
                sb = new StringBuffer();
                f = new Formatter(sb);
                f.format(PROVIDER_FORMAT_LINE, mediaTypeHeader, GENERIC_TYPE, CUSTOM, PROVIDER_CLASS);
            }
            if (counter % 20 != 0) {
                logger.debug("The following JAX-RS {} providers are registered:{}", (Object)providerType, (Object)sb);
            }
        }
    }

    private void logExceptionMapper(List<ProvidersRegistry.ProviderRecord<?>> providerRecords) {
        StringBuffer sb = new StringBuffer();
        if (!providerRecords.isEmpty()) {
            Formatter f = new Formatter(sb);
            f.format(EXCEPTION_MAPPER_FORMAT_LINE, GENERIC_TYPE, CUSTOM, PROVIDER_CLASS);
            int counter = 0;
            for (ProvidersRegistry.ProviderRecord<?> record : providerRecords) {
                f.format(EXCEPTION_MAPPER_FORMAT_LINE, record.getGenericType().getSimpleName(), !record.isSystemProvider(), record.getProviderClass().getName());
                if (++counter % 20 != 0) continue;
                logger.debug("The following JAX-RS {} providers are registered:{}", (Object)"ExceptionMapper", (Object)sb);
                sb = new StringBuffer();
                f = new Formatter(sb);
                f.format(EXCEPTION_MAPPER_FORMAT_LINE, GENERIC_TYPE, CUSTOM, PROVIDER_CLASS);
            }
            if (counter % 20 != 0) {
                logger.debug("The following JAX-RS {} providers are registered:{}", (Object)"ExceptionMapper", (Object)sb);
            }
        }
    }

    private void logTable() {
        List providerRecords = this.providersRegistry.getMessageBodyReaderRecords();
        this.log(providerRecords, "MessageBodyReader", CONSUMES_MEDIA_TYPE);
        providerRecords = this.providersRegistry.getMessageBodyWriterRecords();
        this.log(providerRecords, "MessageBodyWriter", PRODUCES_MEDIA_TYPE);
        providerRecords = this.providersRegistry.getExceptionMapperRecords();
        this.logExceptionMapper(providerRecords);
        providerRecords = this.providersRegistry.getContextResolverRecords();
        this.log(providerRecords, "ContextResolver", PRODUCES_MEDIA_TYPE);
    }
}

