/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.apache.wink.server.handlers.MediaTypeMappingRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaTypeMapper {
    private static final Logger logger = LoggerFactory.getLogger(MediaTypeMapper.class);
    private List<MediaTypeMappingRecord> mappings = new ArrayList<MediaTypeMappingRecord>();

    public void addMappings(List<? extends MediaTypeMappingRecord> records) {
        if (records == null) {
            logger.trace("No media type mapping records to add");
            return;
        }
        logger.trace("Media type mapping records to add: {}", records);
        this.mappings.addAll(records);
    }

    public MediaType mapOutputMediaType(MediaType responseMediaType, HttpHeaders requestHeaders) {
        for (MediaTypeMappingRecord mappingRecord : this.mappings) {
            logger.trace("Attempting to map media type using mapping record: {}", (Object)mappingRecord);
            MediaType replacement = mappingRecord.match(requestHeaders, responseMediaType);
            if (replacement == null) continue;
            logger.trace("Mapped user media type to: {} using mapping record: {}", (Object)replacement, (Object)mappingRecord);
            return replacement;
        }
        logger.trace("Did not find a mapping record so returning original response media type: {}", (Object)responseMediaType);
        return responseMediaType;
    }
}

