/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.handlers;

import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.wink.server.handlers.Handler;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandlersChain<T extends Handler>
implements HandlersChain,
Cloneable {
    private static Logger logger = LoggerFactory.getLogger(AbstractHandlersChain.class);
    private LinkedList<T> list = new LinkedList();
    private ListIterator<T> iterator = null;

    public void addHandler(T handler) {
        this.list.add(handler);
    }

    public void run(MessageContext context) throws Throwable {
        Object clone = this.clone();
        ((AbstractHandlersChain)clone).doChain(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChain(MessageContext context) throws Throwable {
        if (!this.iterator.hasNext()) {
            return;
        }
        try {
            Handler handler = (Handler)this.iterator.next();
            if (logger.isTraceEnabled()) {
                logger.trace("Invoking handler: {}", (Object)handler.getClass().getName());
            }
            this.handle(handler, context);
        }
        finally {
            this.iterator.previous();
        }
    }

    protected AbstractHandlersChain<T> clone() throws CloneNotSupportedException {
        AbstractHandlersChain clone = (AbstractHandlersChain)super.clone();
        clone.iterator = this.list.listIterator();
        return clone;
    }

    protected abstract void handle(T var1, MessageContext var2) throws Throwable;

    public String toString() {
        return String.format("Handlers chain is %1$s", this.list);
    }
}

