/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.providers.json4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.utils.ProviderUtils;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json", "application/javascript"})
@Produces(value={"application/json", "application/javascript"})
public class JSON4JArrayProvider
implements MessageBodyWriter<JSONArray>,
MessageBodyReader<JSONArray> {
    public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return JSONArray.class == clazz;
    }

    public JSONArray readFrom(Class<JSONArray> clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        try {
            return new JSONArray((Reader)new InputStreamReader(is, ProviderUtils.getCharset((MediaType)mediaType)), false);
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    public long getSize(JSONArray obj, Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return JSONArray.class.isAssignableFrom(clazz);
    }

    public void writeTo(JSONArray arr, Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(headers, (MediaType)mediaType);
        OutputStreamWriter writer = new OutputStreamWriter(os, ProviderUtils.getCharset((MediaType)mediaType));
        try {
            Writer json4jWriter = arr.write((Writer)writer);
            json4jWriter.flush();
            writer.flush();
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

