/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.test.mock;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import junit.framework.TestCase;
import org.apache.wink.test.mock.TestUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.ContextLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpringAwareTestCase
extends TestCase {
    protected ApplicationContext applicationContext;
    protected MockServletContext servletContext;

    protected void setUp() throws Exception {
        super.setUp();
        ContextLoader contextLoader = new ContextLoader();
        this.servletContext = new MockServletContext();
        this.servletContext.addInitParameter("contextConfigLocation", this.getApplicationContextPath());
        this.applicationContext = contextLoader.initWebApplicationContext((ServletContext)this.servletContext);
    }

    protected List<String> getAdditionalContextNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("META-INF/server/wink-core-context.xml");
        return arrayList;
    }

    private String getApplicationContextPath() {
        ArrayList<String> contextList = new ArrayList<String>();
        List<String> additionalContextNames = this.getAdditionalContextNames();
        if (!additionalContextNames.isEmpty()) {
            contextList.addAll(additionalContextNames);
        }
        try {
            File file;
            String classPathName = this.getPackagePath() + File.separator + ((Object)((Object)this)).getClass().getSimpleName() + "Context.xml";
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(classPathName);
            if (resource != null && (file = new File(resource.toURI())).isFile()) {
                contextList.add(classPathName);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        StringBuilder buf = new StringBuilder((String)contextList.get(0));
        for (int i = 1; i < contextList.size(); ++i) {
            buf.append(',');
            buf.append((String)contextList.get(i));
        }
        return buf.toString();
    }

    protected String getPackagePath() {
        return TestUtils.packageToPath(((Object)((Object)this)).getClass().getPackage().getName());
    }
}

