/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.test.mock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import org.springframework.mock.web.MockHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletRequestWrapper
extends MockHttpServletRequest {
    private ServletInputStream inputStream = null;
    private boolean done;

    public ServletInputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        this.inputStream = super.getInputStream();
        return this.inputStream;
    }

    public void setContentType(String contentType) {
        if (contentType != null) {
            if (this.getCharacterEncoding() != null && !contentType.contains("charset=")) {
                contentType = contentType + ";charset=" + this.getCharacterEncoding();
            }
            this.addHeader("Content-Type", contentType);
        }
        super.setContentType(contentType);
    }

    public void setContent(byte[] content) {
        super.setContent(content);
        if (content != null) {
            this.addHeader("Content-Length", String.valueOf(content.length));
        }
    }

    public String decode(String s) {
        try {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            return URLDecoder.decode(s, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Map<String, String> decodeForm(String form) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (form != null && form.length() > 0) {
            for (String nvp : form.split("\\&")) {
                String value;
                String name;
                int equals = nvp.indexOf(61);
                if (equals < 0) {
                    name = this.decode(nvp);
                    value = null;
                } else {
                    name = this.decode(nvp.substring(0, equals));
                    value = this.decode(nvp.substring(equals + 1));
                }
                params.put(name, value);
            }
        }
        return params;
    }

    private String readContent() {
        BufferedReader ir;
        try {
            ir = this.getReader();
        }
        catch (UnsupportedEncodingException e1) {
            throw new IllegalArgumentException(e1);
        }
        if (ir == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int size = 0;
            while ((size = ir.read(buffer)) != -1) {
                sb.append(buffer, 0, size);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String string = sb.toString();
        return string.trim();
    }

    private synchronized void readFromForm() {
        if (this.done) {
            return;
        }
        String contentType = this.getContentType();
        if ("POST".equals(this.getMethod()) && contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
            String form = this.readContent();
            this.addParameters(form);
        }
        if ("GET".equals(this.getMethod()) && this.getQueryString() != null) {
            this.addParameters(this.getQueryString());
        }
        this.done = true;
    }

    protected void addParameters(String form) {
        Map<String, String> params = this.decodeForm(form);
        for (Map.Entry<String, String> e : params.entrySet()) {
            this.addParameter(e.getKey(), e.getValue());
        }
    }

    public String getParameter(String name) {
        this.readFromForm();
        return super.getParameter(name);
    }

    public Enumeration getParameterNames() {
        this.readFromForm();
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        this.readFromForm();
        return super.getParameterValues(name);
    }

    public Map getParameterMap() {
        this.readFromForm();
        return super.getParameterMap();
    }
}

