/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinkLogHandler
extends Handler {
    private static List<LogRecord> logRecords = new ArrayList<LogRecord>();
    static boolean storeLogsOn = false;
    static LEVEL level;
    private static WinkLogHandler handler;

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    public static Level getLogLevel() {
        if (level != null) {
            if (level.equals((Object)LEVEL.INFO)) {
                return Level.INFO;
            }
            if (level.equals((Object)LEVEL.DEBUG)) {
                return Level.FINE;
            }
            if (level.equals((Object)LEVEL.TRACE)) {
                return Level.FINEST;
            }
        }
        return Level.OFF;
    }

    @Override
    public void publish(LogRecord record) {
        if (storeLogsOn) {
            if (level.equals((Object)LEVEL.INFO) && record.getLevel().equals(Level.INFO)) {
                logRecords.add(record);
            } else if (level.equals((Object)LEVEL.DEBUG) && record.getLevel().equals(Level.FINE)) {
                logRecords.add(record);
            } else if (level.equals((Object)LEVEL.TRACE) && record.getLevel().equals(Level.FINEST)) {
                logRecords.add(record);
            }
        }
    }

    public static void turnLoggingCaptureOn(LEVEL _level) {
        Logger logger = Logger.getLogger("org.apache.wink");
        if (handler == null) {
            handler = new WinkLogHandler();
            handler.setLevel(Level.FINEST);
        }
        Handler[] handlers = logger.getHandlers();
        WinkLogHandler.clearRecords();
        if (handlers == null || !Arrays.asList(handlers).contains(handler)) {
            logger.addHandler(handler);
        }
        switch (_level) {
            case INFO: {
                logger.setLevel(Level.INFO);
                break;
            }
            case DEBUG: {
                logger.setLevel(Level.FINE);
                break;
            }
            case TRACE: {
                logger.setLevel(Level.FINEST);
            }
        }
        level = _level;
        storeLogsOn = true;
    }

    public static void turnLoggingCaptureOff() {
        Logger logger = Logger.getLogger("org.apache.wink");
        logger.removeHandler(handler);
        logger.setLevel(Level.OFF);
        storeLogsOn = false;
        level = null;
    }

    public static List<LogRecord> getRecords() {
        return logRecords;
    }

    public static List<LogRecord> getRecordsFilteredBy(String logName) {
        ArrayList<LogRecord> filtered = new ArrayList<LogRecord>();
        for (int i = 0; i < logRecords.size(); ++i) {
            if (!logRecords.get(i).getLoggerName().equals(logName)) continue;
            filtered.add(logRecords.get(i));
        }
        return filtered;
    }

    public static void clearRecords() {
        logRecords.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LEVEL {
        INFO,
        DEBUG,
        TRACE;

    }
}

