/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.instrument;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import org.apache.wicket.util.lang.Objects;

public class InstrumentationObjectSizeOfStrategy
implements Objects.IObjectSizeOfStrategy {
    private final Instrumentation instrumentation;

    public InstrumentationObjectSizeOfStrategy(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public long sizeOf(Object obj) {
        if (obj == null) {
            return 0L;
        }
        try {
            SizeRecodingOuputStream recorder = new SizeRecodingOuputStream();
            recorder.writeObject(obj);
            return recorder.getTotalSize();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    private final class SizeRecodingOuputStream
    extends ObjectOutputStream {
        private long totalSize;

        public SizeRecodingOuputStream() throws IOException {
            super(new OutputStream(){

                public void write(int b) throws IOException {
                }
            });
            this.totalSize = 0L;
            this.enableReplaceObject(true);
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        protected Object replaceObject(Object obj) throws IOException {
            if (obj != null) {
                this.totalSize += InstrumentationObjectSizeOfStrategy.this.instrumentation.getObjectSize(obj);
            }
            return obj;
        }
    }
}

