/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.jetty9;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketConnection;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.util.lang.Args;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty9WebSocketConnection
extends AbstractWebSocketConnection {
    private static final Logger LOG = LoggerFactory.getLogger(Jetty9WebSocketConnection.class);
    private final Session session;

    public Jetty9WebSocketConnection(Session session, AbstractWebSocketProcessor webSocketProcessor) {
        super(webSocketProcessor);
        this.session = (Session)Args.notNull((Object)session, (String)"connection");
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    public void close(int code, String reason) {
        if (this.isOpen()) {
            try {
                this.session.close(code, reason);
            }
            catch (IOException iox) {
                LOG.error("An error occurred while closing WebSocket session", (Throwable)iox);
            }
        }
    }

    public IWebSocketConnection sendMessage(String message) throws IOException {
        this.checkClosed();
        this.session.getRemote().sendString(message);
        return this;
    }

    public IWebSocketConnection sendMessage(byte[] message, int offset, int length) throws IOException {
        this.checkClosed();
        ByteBuffer buf = ByteBuffer.wrap(message, offset, length);
        this.session.getRemote().sendBytes(buf);
        return this;
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is closed.");
        }
    }
}

