/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.jetty;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.jetty.Jetty9WebSocketConnection;
import org.eclipse.jetty.websocket.core.api.UpgradeRequest;
import org.eclipse.jetty.websocket.core.api.UpgradeResponse;
import org.eclipse.jetty.websocket.core.api.WebSocketConnection;
import org.eclipse.jetty.websocket.core.api.WebSocketException;
import org.eclipse.jetty.websocket.core.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty9WebSocketProcessor
extends AbstractWebSocketProcessor
implements WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(Jetty9WebSocketProcessor.class);

    public Jetty9WebSocketProcessor(UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse, Application application) {
        super((HttpServletRequest)((HttpServletRequestWrapper)upgradeRequest).getRequest(), application);
    }

    public void onWebSocketConnect(WebSocketConnection connection) {
        this.onConnect(new Jetty9WebSocketConnection(connection));
    }

    public void onWebSocketText(String message) {
        this.onMessage(message);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        this.onMessage(payload, offset, len);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.onClose(statusCode, reason);
    }

    public void onWebSocketException(WebSocketException error) {
        LOG.error("An error occurred when using WebSocket.", (Throwable)error);
    }

    public void onOpen(Object connection) {
        if (!(connection instanceof WebSocketConnection)) {
            throw new IllegalArgumentException(WebSocketConnection.class.getName() + " can work only with " + WebSocketConnection.class.getName());
        }
        this.onWebSocketConnect((WebSocketConnection)connection);
    }
}

