/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.jetty;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.util.lang.Args;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.api.WebSocketConnection;

public class Jetty9WebSocketConnection
implements IWebSocketConnection {
    private final WebSocketConnection connection;

    public Jetty9WebSocketConnection(WebSocketConnection connection) {
        this.connection = (WebSocketConnection)Args.notNull((Object)connection, (String)"connection");
    }

    public boolean isOpen() {
        return this.connection.isOpen();
    }

    public void close(int code, String reason) {
        if (this.isOpen()) {
            this.connection.close(code, reason);
        }
    }

    public IWebSocketConnection sendMessage(String message) throws IOException {
        this.checkClosed();
        FutureCallback waiter = new FutureCallback();
        this.connection.write(null, (Callback)waiter, message);
        this.waitForMessageSent(waiter);
        return this;
    }

    public IWebSocketConnection sendMessage(byte[] message, int offset, int length) throws IOException {
        this.checkClosed();
        FutureCallback waiter = new FutureCallback();
        this.connection.write(null, (Callback)new Callback.Empty(), message, offset, length);
        this.waitForMessageSent(waiter);
        return this;
    }

    private void waitForMessageSent(FutureCallback<?> waiter) throws IOException {
        try {
            waiter.get();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        catch (ExecutionException e) {
            FutureCallback.rethrow((ExecutionException)e);
        }
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is closed.");
        }
    }
}

